/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.JDBCDisplayUtil;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.util.Formatters;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class maxMemPerTab {
    public static void main(String[] stringArray) {
        try {
            ij.getPropertyArg((String[])stringArray);
            Connection connection = ij.startJBMS();
            connection.setAutoCommit(false);
            maxMemPerTab.createTablesAndInsertData(connection);
            maxMemPerTab.getStatistics(connection);
            connection.rollback();
            connection.close();
        }
        catch (SQLException sQLException) {
            TestUtil.dumpSQLExceptions(sQLException);
        }
        catch (Throwable throwable) {
            System.out.println("FAIL -- unexpected exception:" + throwable.toString());
        }
    }

    private static void createTablesAndInsertData(Connection connection) throws SQLException {
        System.out.println("Start creating tables and inserting data ...");
        PreparedStatement preparedStatement = connection.prepareStatement("create table tab1 (c1 int, c2 varchar(20000))");
        preparedStatement.execute();
        preparedStatement = connection.prepareStatement("create table tab2 (c1 int, c2 varchar(20000))");
        preparedStatement.execute();
        preparedStatement = connection.prepareStatement("create table tab3 (c1 int, c2 varchar(2000))");
        preparedStatement.execute();
        preparedStatement = connection.prepareStatement("create table tab4 (c1 int, c2 varchar(2000))");
        preparedStatement.execute();
        String string = new String(Formatters.repeatChar("a", 20000));
        String string2 = new String(Formatters.repeatChar("a", 2000));
        String string3 = new String(Formatters.repeatChar("b", 20000));
        String string4 = new String(Formatters.repeatChar("b", 2000));
        String string5 = new String(Formatters.repeatChar("c", 20000));
        String string6 = new String(Formatters.repeatChar("c", 2000));
        String string7 = new String(Formatters.repeatChar("d", 20000));
        String string8 = new String(Formatters.repeatChar("d", 2000));
        preparedStatement = connection.prepareStatement("insert into tab1 values (?, ?)");
        preparedStatement.setInt(1, 1);
        preparedStatement.setString(2, string);
        preparedStatement.executeUpdate();
        preparedStatement.setInt(1, 2);
        preparedStatement.setString(2, string3);
        preparedStatement.executeUpdate();
        preparedStatement.setInt(1, 3);
        preparedStatement.setString(2, string5);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        preparedStatement = connection.prepareStatement("insert into tab2 values (?, ?)");
        preparedStatement.setInt(1, 1);
        preparedStatement.setString(2, string);
        preparedStatement.executeUpdate();
        preparedStatement.setInt(1, 2);
        preparedStatement.setString(2, string5);
        preparedStatement.executeUpdate();
        preparedStatement.setInt(1, 3);
        preparedStatement.setString(2, string7);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        preparedStatement = connection.prepareStatement("insert into tab3 values (?, ?)");
        preparedStatement.setInt(1, 1);
        preparedStatement.setString(2, string2);
        preparedStatement.executeUpdate();
        preparedStatement.setInt(1, 2);
        preparedStatement.setString(2, string4);
        preparedStatement.executeUpdate();
        preparedStatement.setInt(1, 3);
        preparedStatement.setString(2, string6);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        preparedStatement = connection.prepareStatement("insert into tab4 values (?, ?)");
        preparedStatement.setInt(1, 1);
        preparedStatement.setString(2, string2);
        preparedStatement.executeUpdate();
        preparedStatement.setInt(1, 2);
        preparedStatement.setString(2, string6);
        preparedStatement.executeUpdate();
        preparedStatement.setInt(1, 3);
        preparedStatement.setString(2, string8);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        System.out.println("... done creating tables and inserting data.");
    }

    private static void getStatistics(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        System.out.println("Called SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        JDBCDisplayUtil.setMaxDisplayWidth((int)2500);
        maxMemPerTab.executeQuery(statement, connection, "select * from tab1, tab2 where tab1.c2 = tab2.c2");
        maxMemPerTab.executeQuery(statement, connection, "values SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
        maxMemPerTab.executeQuery(statement, connection, "select * from tab3, tab4 where tab3.c2 = tab4.c2");
        maxMemPerTab.executeQuery(statement, connection, "values SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
        statement.close();
    }

    private static void executeQuery(Statement statement, Connection connection, String string) throws SQLException {
        System.out.println("#### Executing \"" + string + "\"");
        ResultSet resultSet = statement.executeQuery(string);
        JDBCDisplayUtil.DisplayResults((PrintStream)System.out, (ResultSet)resultSet, (Connection)connection);
        resultSet.close();
    }
}

