/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class InsertTest
extends BaseJDBCTestCase {
    private static final String PARAMETER_IN_SELECT_LIST = "42X34";
    private static final String TOO_MANY_RESULT_COLUMNS = "42X06";

    public InsertTest(String string) {
        super(string);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(InsertTest.class);
    }

    public void zztestDerby6788() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("CREATE TABLE M1 (K varchar(64), S decimal)");
        statement.execute("CREATE TABLE M2 (K varchar(64), S decimal)");
        statement.execute("CREATE TABLE V  (S DECIMAL)");
        statement.execute("INSERT INTO M1 VALUES ('Bug', 2015)");
        statement.execute("INSERT INTO M2 VALUES ('Bug', 1957)");
        JDBC.assertFullResultSet(statement.executeQuery("SELECT res.* FROM (SELECT d2.s FROM m1 LEFT JOIN (SELECT k,s FROM m2) AS d2 ON m1.k=d2.k) AS res"), new String[][]{{"1957"}});
        statement.execute("INSERT INTO V (SELECT res.* FROM (SELECT d2.s FROM m1 LEFT JOIN (SELECT k,s FROM m2) AS d2 ON m1.k=d2.k) AS res)");
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM V"), new String[][]{{"1957"}});
        statement.execute("INSERT INTO V (SELECT res.* FROM (SELECT d2.s*1 FROM m1 LEFT JOIN (SELECT k,s FROM m2) AS d2 ON m1.k=d2.k) AS res)");
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM V"), new String[][]{{"1957"}, {"1957"}});
        statement.execute("DROP   TABLE M1");
        statement.execute("DROP   TABLE M2");
        statement.execute("DROP   TABLE V");
    }

    public void testDerby6786Case1() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("CREATE TABLE K1 (K VARCHAR(64), S DECIMAL)");
        statement.execute("CREATE TABLE K2 (K VARCHAR(64), S DECIMAL)");
        statement.execute("CREATE TABLE T  (S DECIMAL)");
        statement.execute("INSERT INTO K1 VALUES ('110007', 224)");
        statement.execute("INSERT INTO K2 VALUES ('110007', 361)");
        this.derby6786QueriesToRun(statement, "");
        this.derby6786QueriesToRun(statement, "insert into t ");
        statement.execute("DROP   TABLE K1");
        statement.execute("DROP   TABLE K2");
        statement.execute("DROP   TABLE T");
    }

    public void testDerby6786InsertIntoSelectCase2() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("CREATE TABLE K1 (K VARCHAR(64), S DECIMAL)");
        statement.execute("CREATE TABLE K2 (K VARCHAR(64), S DECIMAL)");
        statement.execute("CREATE TABLE T  (S DECIMAL)");
        statement.execute("INSERT INTO K1 VALUES ('110007', 224)");
        statement.execute("INSERT INTO K2 VALUES ('110007', null)");
        this.derby6786QueriesToRun(statement, "");
        this.derby6786QueriesToRun(statement, "insert into t ");
        statement.execute("DROP   TABLE K1");
        statement.execute("DROP   TABLE K2");
        statement.execute("DROP   TABLE T");
    }

    public void zztestDerby6786InsertIntoSelectCase3() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("CREATE TABLE K1 (K VARCHAR(64), S DECIMAL)");
        statement.execute("CREATE TABLE K2 (K VARCHAR(64), S DECIMAL)");
        statement.execute("CREATE TABLE T  (S DECIMAL)");
        statement.execute("INSERT INTO K1 VALUES ('110007', 224)");
        statement.execute("INSERT INTO K2 VALUES ('110019', null)");
        this.derby6786QueriesToRun(statement, "");
        this.derby6786QueriesToRun(statement, "insert into t ");
        statement.execute("DROP   TABLE K1");
        statement.execute("DROP   TABLE K2");
        statement.execute("DROP   TABLE T");
    }

    private void derby6786QueriesToRun(Statement statement, String string) throws SQLException {
        statement.execute(string + "select erg.* from ( select d1.s from (select k,s from k1) as d1 left join (select k,s from k2) as d2 on d1.k=d2.k) as erg where s > 10");
        statement.execute(string + "select erg.* from ( select d2.s from (select k,s from k1) as d1 left join (select k,s from k2) as d2 on d1.k=d2.k) as erg where s > 10");
        statement.execute(string + "select erg.* from ( select d2.s from k1 left join (select k,s from k2) as d2 on k1.k=d2.k) as erg where s > 10");
        statement.execute(string + "select erg.* from ( select d1.s from (select k,s from k1) as d1 right join (select k,s from k2) as d2 on d1.k=d2.k) as erg where s > 10");
        statement.execute(string + "select erg.* from ( select d2.s from (select k,s from k1) as d1 right join (select k,s from k2) as d2 on d1.k=d2.k) as erg where s > 10");
    }

    public void testInsertIntoSelectFromWithLongVarchar() throws SQLException {
        String[][] stringArray = new String[100][2];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i][0] = Integer.toString(i);
            stringArray[i][1] = "-1";
        }
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create table t1(a long varchar)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into t1 values ?");
        for (int i = 0; i < stringArray.length; ++i) {
            preparedStatement.setString(1, stringArray[i][0]);
            preparedStatement.executeUpdate();
        }
        statement.execute("create table t2(a long varchar, b int default -1 not null)");
        statement.execute("insert into t2(a) select * from t1");
        JDBC.assertFullResultSet(statement.executeQuery("select * from t2 order by int(cast (a as varchar(10)))"), stringArray);
    }

    public void testInsertFromExceptOrIntersect() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create table t1(x int)");
        statement.execute("insert into t1 values 1,2,3");
        statement.execute("create table t2(x int)");
        statement.execute("insert into t2 values 2,3,4");
        statement.execute("create table t3(x int)");
        statement.execute("insert into t3 select * from t1 intersect select * from t2");
        JDBC.assertFullResultSet(statement.executeQuery("select * from t3 order by x"), new String[][]{{"2"}, {"3"}});
        statement.execute("delete from t3");
        statement.execute("insert into t3 select * from t1 intersect all select * from t2");
        JDBC.assertFullResultSet(statement.executeQuery("select * from t3 order by x"), new String[][]{{"2"}, {"3"}});
        statement.execute("delete from t3");
        statement.execute("insert into t3 select * from t1 except select * from t2");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select * from t3 order by x"), "1");
        statement.execute("delete from t3");
        statement.execute("insert into t3 select * from t1 except all select * from t2");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select * from t3 order by x"), "1");
        statement.execute("delete from t3");
    }

    public void testInsertFromSelectWithParameters() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table derby4671(x int)");
        statement.execute("insert into derby4671 values (1), (2)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into derby4671 select ? from derby4671");
        preparedStatement.setInt(1, 7);
        InsertTest.assertUpdateCount(preparedStatement, 2);
        JDBC.assertFullResultSet(statement.executeQuery("select * from derby4671 order by x"), new String[][]{{"1"}, {"2"}, {"7"}, {"7"}});
        PreparedStatement preparedStatement2 = this.prepareStatement("insert into derby4671 select (x+?)*10 from derby4671");
        preparedStatement2.setInt(1, 77);
        InsertTest.assertUpdateCount(preparedStatement2, 4);
        JDBC.assertFullResultSet(statement.executeQuery("select * from derby4671 order by x"), new String[][]{{"1"}, {"2"}, {"7"}, {"7"}, {"780"}, {"790"}, {"840"}, {"840"}});
        this.assertCompileError(PARAMETER_IN_SELECT_LIST, "insert into derby4671 select ? from derby4671 union select ? from derby4671");
        this.assertCompileError(PARAMETER_IN_SELECT_LIST, "insert into derby4671 select ? from derby4671 except select ? from derby4671");
        this.assertCompileError(PARAMETER_IN_SELECT_LIST, "insert into derby4671 select ? from derby4671 intersect select ? from derby4671");
    }

    public void testInsertTooManyDefaultColumns() throws SQLException {
        this.createStatement().execute("create table derby4449(x int)");
        this.assertCompileError(TOO_MANY_RESULT_COLUMNS, "insert into derby4449 values (default, default)");
        this.assertCompileError(TOO_MANY_RESULT_COLUMNS, "insert into derby4449 (x) values (default, default)");
    }

    public void testDerby6443() throws SQLException {
        Statement statement = this.createStatement();
        this.setAutoCommit(false);
        statement.execute("CREATE SCHEMA d6443");
        statement.execute("SET SCHEMA d6443");
        statement.execute("CREATE TABLE foo (name VARCHAR(20), val DOUBLE)");
        statement.execute("CREATE TABLE summary (name VARCHAR(20), aver DOUBLE, size INT)");
        statement.execute("CREATE TRIGGER trg_foo AFTER INSERT ON foo REFERENCING NEW TABLE AS changed FOR EACH STATEMENT INSERT INTO summary (name, aver, size) SELECT name, FLOOR(AVG(LOG10(val))), COUNT(*) FROM changed GROUP BY name");
        statement.execute("INSERT INTO foo (name, val) VALUES ('A', 10), ('A', 20), ('B', 30), ('C', 40)");
        JDBC.assertFullResultSet(statement.executeQuery("select * from foo order by val"), new String[][]{{"A", "10.0"}, {"A", "20.0"}, {"B", "30.0"}, {"C", "40.0"}});
        JDBC.assertFullResultSet(statement.executeQuery("select * from summary order by name"), new String[][]{{"A", "1.0", "2"}, {"B", "1.0", "1"}, {"C", "1.0", "1"}});
        statement.execute("create table t1(x int)");
        statement.execute("insert into t1 values 1");
        statement.execute("create table t2(x int)");
        statement.execute("insert into t2 select floor(avg(x)) from t1");
        statement.execute("create function f(x int) returns int language java parameter style java external name 'java.lang.Math.abs'");
        statement.execute("insert into t2 select f(avg(x)) from t1");
        statement.execute("insert into t2 select f((select x from t1)) from t1");
        JDBC.assertFullResultSet(statement.executeQuery("select * from t2"), new String[][]{{"1"}, {"1"}, {"1"}});
    }
}

