/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class DropTableTest
extends BaseJDBCTestCase {
    public DropTableTest(String string) {
        super(string);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(DropTableTest.class);
    }

    public void testDropTableWithConstraints() throws Exception {
        Statement statement = this.createStatement();
        this.setAutoCommit(false);
        statement.executeUpdate("create table t1 ( a int)");
        statement.executeUpdate(" drop table t1");
        DropTableTest.assertStatementError("42X05", statement, "select * from t1");
        statement.executeUpdate("create table t1 (a int not null unique)");
        statement.executeUpdate(" drop table t1");
        DropTableTest.assertStatementError("42X05", statement, "select * from t1");
        statement.executeUpdate("create table t1 ( a int not null primary key)");
        statement.executeUpdate(" drop table t1");
        DropTableTest.assertStatementError("42X05", statement, "select * from t1");
        statement.executeUpdate("create table t1 ( a int check(a > 0))");
        statement.executeUpdate(" drop table t1");
        DropTableTest.assertStatementError("42X05", statement, "select * from t1");
        statement.executeUpdate("create table t1 ( a int)");
        statement.executeUpdate(" create index t1index on t1(a)");
        statement.executeUpdate(" drop table t1");
        DropTableTest.assertStatementError("42X05", statement, "select * from t1");
        statement.executeUpdate("create table t1(a int not null primary key)");
        statement.executeUpdate(" create table t2(a int constraint reft1a references t1(a))");
        DropTableTest.assertStatementError("X0Y25", statement, "drop table t1");
        statement.executeUpdate("alter table t2 drop constraint reft1a");
        statement.executeUpdate("drop table t1");
        DropTableTest.assertStatementError("42X05", statement, "select * from t1");
        statement.executeUpdate("insert into t2 values(1)");
        statement.executeUpdate(" drop table t2");
    }

    public void testDropTableWithView() throws SQLException {
        Statement statement = this.createStatement();
        this.setAutoCommit(false);
        statement.executeUpdate("create table t1(a int, b int)");
        statement.executeUpdate(" create table t2(c int, d int)");
        statement.executeUpdate(" create view vt1a as select a from t1");
        statement.executeUpdate(" create view vt1b as select b from t1");
        statement.executeUpdate(" create view vt1t2 as select * from t1, t2");
        statement.executeUpdate(" create view vvt1a as select * from vt1a");
        statement.executeUpdate(" create view vvvt1a as select * from vvt1a");
        DropTableTest.assertStatementError("X0Y23", statement, "drop table t1");
        statement.executeUpdate("drop view vvvt1a");
        statement.executeUpdate(" drop view vvt1a");
        statement.executeUpdate(" drop view vt1t2");
        statement.executeUpdate(" drop view vt1b");
        statement.executeUpdate(" drop view vt1a");
        statement.executeUpdate("drop table t1");
        DropTableTest.assertStatementError("42X05", statement, "select * from vt1a");
        DropTableTest.assertStatementError("42X05", statement, " select * from vt1b");
        DropTableTest.assertStatementError("42X05", statement, " select * from vt1t2");
        DropTableTest.assertStatementError("42X05", statement, " select * from vvt1a");
        DropTableTest.assertStatementError("42X05", statement, " select * from vvvt1a");
        statement.executeUpdate(" drop table t2");
    }

    public void testDropTableWithPreparedStatement() throws SQLException {
        Statement statement = this.createStatement();
        this.setAutoCommit(false);
        statement.executeUpdate("create table t1(a int)");
        PreparedStatement preparedStatement = this.prepareStatement("select * from t1");
        statement.executeUpdate("drop table t1");
        DropTableTest.assertStatementError("42X05", preparedStatement);
    }

    public void testDropTableWithTriggers() throws SQLException {
        Statement statement = this.createStatement();
        this.setAutoCommit(false);
        statement.executeUpdate("create table t1(a int)");
        statement.executeUpdate(" create table t2(a int)");
        statement.executeUpdate(" create trigger t1trig after insert on t1 for each row insert into t2 values(1)");
        statement.executeUpdate("drop table t1");
        DropTableTest.assertStatementError("42X05", statement, "select * from t1");
        statement.executeUpdate(" drop table t2");
        statement.executeUpdate("create table t1(a int)");
        statement.executeUpdate(" create table t2(a int)");
        statement.executeUpdate(" create trigger t2trig after insert on t2 for each row insert into t1 values(1)");
        DropTableTest.assertStatementError("X0Y25", statement, "drop table t1");
        statement.executeUpdate("insert into t2 values(1)");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select * from t1"), "1");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select * from t2"), "1");
        statement.executeUpdate(" drop table t2");
        statement.executeUpdate(" drop table t1");
    }

    public void testDropTableDropView() throws SQLException {
        Statement statement = this.createStatement();
        this.setAutoCommit(false);
        statement.executeUpdate("create table t1(a int)");
        statement.executeUpdate(" create view vt1 as select * from t1");
        statement.executeUpdate(" create view vvt1 as select * from vt1");
        DropTableTest.assertStatementError("X0Y23", statement, "drop view vt1");
        DropTableTest.assertStatementError("42X01", statement, " drop view vt1 restrict");
        DropTableTest.assertStatementError("42X01", statement, " drop view vt1 cascade");
        statement.executeUpdate("drop view vvt1");
        statement.executeUpdate("drop view  vt1");
        statement.executeUpdate("drop table  t1");
    }

    public void testDropTableIndexesDropped() throws SQLException {
        Statement statement = this.createStatement();
        this.setAutoCommit(false);
        statement.executeUpdate("create table t2(a int not null primary key)");
        statement.executeUpdate("create table reft2(a int constraint ref1 references t2)");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from (sys.sysconglomerates c), (sys.systables t) where t.tableid = c.tableid and t.tablename = 'REFT2'"), "2");
        statement.executeUpdate("alter table reft2 drop constraint ref1");
        statement.executeUpdate("drop table t2");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from (sys.sysconglomerates c), (sys.systables t) where t.tableid = c.tableid and t.tablename = 'REFT2'"), "1");
        this.rollback();
        statement.executeUpdate(" create table T1 (i int, c varchar(255), d varchar(255))");
        statement.executeUpdate(" insert into T1(i) values(1)");
        statement.executeUpdate(" insert into T1(i) values(2)");
        Statement statement2 = this.createStatement();
        statement2.setCursorName("X1");
        ResultSet resultSet = statement2.executeQuery("select i from t1 for update of c");
        PreparedStatement preparedStatement = this.prepareStatement("update t1 set c = CHAR(i) where current of X1");
        DropTableTest.assertStatementError("X0X95", statement, "drop table T1");
        resultSet.next();
        preparedStatement.executeUpdate();
        ResultSet resultSet2 = statement.executeQuery("select * from T1");
        String[] stringArray = new String[]{"I", "C", "D"};
        JDBC.assertColumnNames(resultSet2, stringArray);
        String[][] stringArray2 = new String[][]{{"1", "1", null}, {"2", null, null}};
        JDBC.assertFullResultSet(resultSet2, stringArray2);
        statement2.close();
        statement.executeUpdate("drop table T1");
        this.setAutoCommit(true);
    }
}

