/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SQLUtilities;
import org.apache.derbyTesting.junit.TestConfiguration;

public class CaseExpressionTest
extends BaseJDBCTestCase {
    private static String[][] columnReferenceResults = new String[][]{{null, "0", "1", "2"}, {null, "0", "1", "21"}, {null, "0", "1", "22"}, {null, "0.00000", "1.00000", "23.00000"}, {null, "0.0", "1.0", "24.0"}, {null, "0.0", "1.0", "25.0"}, {null, "0                                                           ", "aa                                                          ", "2.0                                                         "}, {null, "0", "aa", "15:30:20"}, {null, "0", "aa", "2000-01-01 15:30:20"}, {null, "10aa20202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020", null, "10aaaa202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020"}, {null, "10aa", null, "10aaba"}, {null, "10aa", null, "10aaca"}, {null, "13", "14", null}, {null, "2000-01-01", "2000-01-01", null}, {null, "15:30:20", "15:30:20", "15:30:20"}, {null, "2000-01-01 15:30:20.0", "2000-01-01 15:30:20.0", "2000-01-01 15:30:20.0"}, {null, null, null, null}};
    private static String[][] nullValueResults = new String[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}};
    private static final AtomicInteger callCount = new AtomicInteger();

    public CaseExpressionTest(String string) {
        super(string);
    }

    public void testWhenNonBoolean() {
        String[] stringArray = new String[]{"SQRT(?)", "SQRT(9)", "UPPER(?)", "UPPER('haight')", "LOWER(?)", "LOWER('HAIGHT')"};
        for (int i = 0; i < stringArray.length; ++i) {
            this.assertCompileError("42X88", "VALUES CASE WHEN " + stringArray[i] + " THEN 3 ELSE 4 END");
        }
    }

    public void testAllDatatypesCombinationsForCaseExpressions() throws SQLException {
        Statement statement = this.createStatement();
        this.testCaseExpressionQuery(statement, columnReferenceResults, "SELECT CASE WHEN 1 = 1 THEN ", " ELSE NULL END from AllDataTypesTable");
        this.testCaseExpressionQuery(statement, columnReferenceResults, "SELECT CASE WHEN 1 = 1 THEN (CASE WHEN 1 = 1 THEN ", " ELSE NULL END) ELSE NULL END from AllDataTypesTable");
        this.testCaseExpressionQuery(statement, nullValueResults, "SELECT CASE WHEN 1 = 1 THEN NULL ELSE ", " END from AllDataTypesTable");
        this.testCaseExpressionQuery(statement, nullValueResults, "SELECT CASE WHEN 1 = 1 THEN (CASE WHEN 1 = 1 THEN NULL ELSE ", " END) ELSE NULL END from AllDataTypesTable");
        this.testCaseExpressionQuery(statement, nullValueResults, "SELECT CASE WHEN 1 = 1 THEN NULL ELSE (CASE WHEN 1 = 1 THEN ", " ELSE NULL END) END from AllDataTypesTable");
        this.testCaseExpressionQuery(statement, nullValueResults, "SELECT CASE WHEN 1 = 1 THEN NULL ELSE (CASE WHEN 1 = 1 THEN NULL ELSE ", " END) END from AllDataTypesTable");
        statement.close();
    }

    public void testMultipleWhens() throws SQLException {
        Statement statement = this.createStatement();
        JDBC.assertFullResultSet(statement.executeQuery("values CASE WHEN 10 = 1 THEN 'a' WHEN 10 = 2 THEN 'b' WHEN 10 = 3 THEN 'c' WHEN 10 = 4 THEN 'd' WHEN 10 = 5 THEN 'e' WHEN 10 = 6 THEN 'f' WHEN 10 = 7 THEN 'g' WHEN 10 = 8 THEN 'h' WHEN 10 = 11 THEN 'i' WHEN 10 = 12 THEN 'j' WHEN 10 = 15 THEN 'k' WHEN 10 = 16 THEN 'l' WHEN 10 = 23 THEN 'm' WHEN 10 = 24 THEN 'n' WHEN 10 = 27 THEN 'o' WHEN 10 = 31 THEN 'p' WHEN 10 = 41 THEN 'q' WHEN 10 = 42 THEN 'r' WHEN 10 = 50 THEN 's' ELSE '*' END"), new String[][]{{"*"}});
        statement.close();
    }

    public void testBooleanExpressions() throws SQLException {
        Statement statement = this.createStatement();
        JDBC.assertFullResultSet(statement.executeQuery("select case when a or b then b or c else a or c end,\n   case when a and b then b and c else a and c end,\n   case when (a or b) then (b or c) else (a or c) end,\n   case when (a and b) then (b and c) else (a and c) end\nfrom (values (true, true, true), (true, true, false),\n             (true, false, true), (true, false, false),\n             (false, true, true), (false, true, false),\n             (false, false, true), (false, false, false)\n      ) v(a, b, c)\norder by a desc, b desc, c desc"), new String[][]{{"true", "true", "true", "true"}, {"true", "false", "true", "false"}, {"true", "true", "true", "true"}, {"false", "false", "false", "false"}, {"true", "false", "true", "false"}, {"true", "false", "true", "false"}, {"true", "false", "true", "false"}, {"false", "false", "false", "false"}});
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = (BaseTestSuite)TestConfiguration.embeddedSuite(CaseExpressionTest.class);
        return new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                SQLUtilities.createAndPopulateAllDataTypesTable(statement);
            }
        };
    }

    private void testCaseExpressionQuery(Statement statement, String[][] stringArray, String string, String string2) throws SQLException {
        for (int i = 0; i < SQLUtilities.SQLTypes.length; ++i) {
            ResultSet resultSet = statement.executeQuery(string + SQLUtilities.allDataTypesColumnNames[i] + string2);
            int n = 0;
            while (resultSet.next()) {
                String string3 = resultSet.getString(1);
                CaseExpressionTest.assertEquals((String)stringArray[i][n], (String)string3);
                ++n;
            }
            resultSet.close();
        }
    }

    public void testDerby3032() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t (d date, vc varchar(30))");
        statement.executeUpdate("insert into t values(CURRENT_DATE, 'hello')");
        ResultSet resultSet = statement.executeQuery("SELECT d from t where d = (SELECT CASE WHEN 1 = 1 THEN CURRENT_DATE ELSE NULL END from t)");
        JDBC.assertDrainResults(resultSet, 1);
        resultSet = statement.executeQuery("SELECT d from t where d = (SELECT CASE WHEN 1 = 1 THEN NULL  ELSE CURRENT_DATE  END from t)");
        JDBC.assertEmpty(resultSet);
        resultSet = statement.executeQuery("SELECT d from t where d = (SELECT CASE WHEN 1 = 0 THEN CURRENT_DATE  ELSE NULL END from t)");
        JDBC.assertEmpty(resultSet);
        resultSet = statement.executeQuery("SELECT CASE WHEN 1 = 1 THEN NULL  ELSE CURRENT_DATE  END from t");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        CaseExpressionTest.assertEquals((int)91, (int)resultSetMetaData.getColumnType(1));
        CaseExpressionTest.assertEquals((int)1, (int)resultSetMetaData.isNullable(1));
        JDBC.assertSingleValueResultSet(resultSet, null);
        resultSet = statement.executeQuery("SELECT CASE WHEN 1 = 0 THEN CURRENT_DATE ELSE NULL END from t");
        resultSetMetaData = resultSet.getMetaData();
        CaseExpressionTest.assertEquals((int)91, (int)resultSetMetaData.getColumnType(1));
        CaseExpressionTest.assertEquals((int)1, (int)resultSetMetaData.isNullable(1));
        JDBC.assertSingleValueResultSet(resultSet, null);
        resultSet = statement.executeQuery("SELECT CASE WHEN 1 = 0 THEN CURRENT_DATE END from t");
        resultSetMetaData = resultSet.getMetaData();
        CaseExpressionTest.assertEquals((int)91, (int)resultSetMetaData.getColumnType(1));
        CaseExpressionTest.assertEquals((int)1, (int)resultSetMetaData.isNullable(1));
        JDBC.assertSingleValueResultSet(resultSet, null);
        resultSet = statement.executeQuery("SELECT CASE WHEN 1 = 0 THEN 6 ELSE 4 END from t");
        resultSetMetaData = resultSet.getMetaData();
        CaseExpressionTest.assertEquals((int)4, (int)resultSetMetaData.getColumnType(1));
        CaseExpressionTest.assertEquals((int)0, (int)resultSetMetaData.isNullable(1));
        JDBC.assertSingleValueResultSet(resultSet, "4");
        resultSet = statement.executeQuery("SELECT CASE WHEN 1 = 1 THEN 6 ELSE 4 END from t");
        resultSetMetaData = resultSet.getMetaData();
        CaseExpressionTest.assertEquals((int)4, (int)resultSetMetaData.getColumnType(1));
        CaseExpressionTest.assertEquals((int)0, (int)resultSetMetaData.isNullable(1));
        JDBC.assertSingleValueResultSet(resultSet, "6");
    }

    public void testNotElimination() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create table d6563(b1 boolean, b2 boolean, b3 boolean)");
        Boolean[] booleanArray = new Boolean[]{true, false, null};
        PreparedStatement preparedStatement = this.prepareStatement("insert into d6563 values (?, ?, ?)");
        for (Boolean bl : booleanArray) {
            preparedStatement.setObject(1, bl);
            for (Boolean bl2 : booleanArray) {
                preparedStatement.setObject(2, bl2);
                for (Boolean bl3 : booleanArray) {
                    preparedStatement.setObject(3, bl3);
                    preparedStatement.executeUpdate();
                }
            }
        }
        Boolean[] booleanArray2 = new Object[][]{{false, false, false, false, true}, {false, false, true, true, false}, {false, false, null, null, null}, {false, true, false, false, true}, {false, true, true, true, false}, {false, true, null, null, null}, {false, null, false, false, true}, {false, null, true, true, false}, {false, null, null, null, null}, {true, false, false, false, true}, {true, false, true, false, true}, {true, false, null, false, true}, {true, true, false, true, false}, {true, true, true, true, false}, {true, true, null, true, false}, {true, null, false, null, null}, {true, null, true, null, null}, {true, null, null, null, null}, {null, false, false, false, true}, {null, false, true, true, false}, {null, false, null, null, null}, {null, true, false, false, true}, {null, true, true, true, false}, {null, true, null, null, null}, {null, null, false, false, true}, {null, null, true, true, false}, {null, null, null, null, null}};
        JDBC.assertFullResultSet(statement.executeQuery("select b1, b2, b3, case when b1 then b2 else b3 end, not case when b1 then b2 else b3 end from d6563 order by b1, b2, b3"), (Object[][])booleanArray2, false);
        ArrayList<T[]> arrayList = new ArrayList<T[]>();
        for (Boolean bl : booleanArray2) {
            if (bl[4] != Boolean.TRUE) continue;
            arrayList.add(Arrays.copyOf(bl, 3));
        }
        booleanArray2 = (Object[][])arrayList.toArray((T[])new Object[arrayList.size()][]);
        JDBC.assertFullResultSet(statement.executeQuery("select * from d6563 where not case when b1 then b2 else b3 end order by b1, b2, b3"), (Object[][])booleanArray2, false);
    }

    public void testParameters() throws SQLException {
        this.assertCompileError("42X87", "values case when true then ? else ? end");
        PreparedStatement preparedStatement = this.prepareStatement("values case when true then ? else 1 end");
        CaseExpressionTest.assertEquals((int)1, (int)preparedStatement.getMetaData().isNullable(1));
        preparedStatement.setNull(1, 4);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        preparedStatement.setInt(1, 1);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "1");
        preparedStatement = this.prepareStatement("values case when true then ? else cast(? as integer) end");
        ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
        CaseExpressionTest.assertEquals((int)4, (int)parameterMetaData.getParameterType(1));
        CaseExpressionTest.assertEquals((int)4, (int)parameterMetaData.getParameterType(2));
        preparedStatement.setInt(1, 1);
        preparedStatement.setInt(2, 2);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "1");
        preparedStatement = this.prepareStatement("values case when ? then 1 else 0 end");
        CaseExpressionTest.assertEquals((int)16, (int)preparedStatement.getParameterMetaData().getParameterType(1));
        preparedStatement.setBoolean(1, true);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "1");
        preparedStatement.setBoolean(1, false);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "0");
        preparedStatement.setNull(1, 16);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "0");
    }

    public void testUntypedNulls() throws SQLException {
        String[] stringArray;
        Statement statement = this.createStatement();
        for (String string : stringArray = new String[]{"values case when true then null end", "values case when true then null else null end", "values case when true then null when false then null else null end", "values case when true then ? end", "values case when true then null else ? end", "values case when true then ? when false then ? else null end", "values case when true then ? else ? end", "values case when true then ? when false then ? else ? end"}) {
            this.assertCompileError("42X87", string);
        }
        JDBC.assertFullResultSet(statement.executeQuery("select case when a then 1 when b then null end, case when a then null when b then 1 end, case when a then null when b then null else 1 end from (values (false, false), (false, true),  (true, false), (true, true)) v(a, b) order by a, b"), (Object[][])new Object[][]{{null, null, 1}, {null, 1, null}, {1, null, null}, {1, null, null}}, false);
        this.assertCompileError("42X89", "values case when 1<>1 then 'abc' else cast(null as smallint) end");
    }

    public void testQuantifiedComparison() throws SQLException {
        JDBC.assertUnorderedResultSet(this.createStatement().executeQuery("select c, case when c = all (values 'Y') then true end from (values 'Y', 'N') v(c)"), new String[][]{{"N", null}, {"Y", "true"}});
    }

    public void testSimpleCaseSyntax() throws SQLException {
        Statement statement = this.createStatement();
        JDBC.assertUnorderedResultSet(statement.executeQuery("select i, case i when 0 then 'zero' when 1 then 'one' when 1+1 then 'two' else 'many' end from (values 0, 1, 2, 3, cast(null as int)) v(i)"), new String[][]{{"0", "zero"}, {"1", "one"}, {"2", "two"}, {"3", "many"}, {null, "many"}});
        JDBC.assertFullResultSet(statement.executeQuery("select i, case i when < 0 then 'negative' when < 10 then 'small' when between 10 and 20 then 'medium' when in (19, 23, 29, 37, 41) then 'prime' when = some (values 7, 42) then 'lucky number' when >= 40 then 'big' end from (values -1, 0, 1, 2, 3, 8, 9, 10, 17, 19, 29, 37, 38, 39, 40, 41, 42, 50) v(i) order by i"), new String[][]{{"-1", "negative"}, {"0", "small"}, {"1", "small"}, {"2", "small"}, {"3", "small"}, {"8", "small"}, {"9", "small"}, {"10", "medium"}, {"17", "medium"}, {"19", "medium"}, {"29", "prime"}, {"37", "prime"}, {"38", null}, {"39", null}, {"40", "big"}, {"41", "prime"}, {"42", "lucky number"}, {"50", "big"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select c, case c when like 'abc%' then 0 when like 'x%%' escape 'x' then 1 when = all (select ibmreqd from sysibm.sysdummy1) then 2 when 'xyz' || 'zyx' then 3 when is null then 4 when is not null then 5 end from (values 'abcdef', 'xyzzyx', '%s', 'hello', cast(null as char(1)), 'Y', 'N') v(c)"), new String[][]{{"abcdef", "0"}, {"xyzzyx", "3"}, {"%s", "1"}, {"hello", "5"}, {null, "4"}, {"Y", "2"}, {"N", "5"}});
        JDBC.assertFullResultSet(statement.executeQuery("select i, case i when between 2 and 3, 5, =7 then 'prime' when <1, >7 then 'out of range' when is not null then 'small' end from (values 0, 1, 2, 3, 4, 5, 6, 7, 8, cast(null as int)) as v(i) order by i"), new String[][]{{"0", "out of range"}, {"1", "small"}, {"2", "prime"}, {"3", "prime"}, {"4", "small"}, {"5", "prime"}, {"6", "small"}, {"7", "prime"}, {"8", "out of range"}, {null, null}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select c, case c when in ('ab', 'cd'), like '_' then 'matched' else 'not matched' end from (values cast('a' as varchar(1)), 'b', 'c', 'ab', 'cd', 'ac', 'abc') v(c)"), new String[][]{{"a", "matched"}, {"b", "matched"}, {"c", "matched"}, {"ab", "matched"}, {"cd", "matched"}, {"ac", "not matched"}, {"abc", "not matched"}});
        this.assertCompileError("42X01", "values case null when 1 then 'one' end");
        JDBC.assertSingleValueResultSet(statement.executeQuery("values case cast(null as int) when 1 then 'one' end"), null);
        this.assertCompileError("42X01", "values case 1 when null then 'null' end");
        JDBC.assertUnorderedResultSet(statement.executeQuery("select i, case i when is null then 1 when is not null then 2 else 3 end from (values 1, cast(null as int)) v(i)"), new String[][]{{"1", "2"}, {null, "1"}});
        this.assertCompileError("42Y98", "values case sysfun.random() when 1 then true else false end");
        this.assertCompileError("42Y98", "values case (values sysfun.random()) when 1 then true else false end");
        JDBC.assertFullResultSet(statement.executeQuery("select case sysfun.sin(angle) when < 0 then 'negative' when > 0 then 'positive' end from (values -pi()/2, 0, pi()/2) v(angle) order by angle"), new String[][]{{"negative"}, {null}, {"positive"}});
        JDBC.assertDrainResults(statement.executeQuery("values case 1 when sysfun.random() then sysfun.random() end"), 1);
        JDBC.assertSingleValueResultSet(statement.executeQuery("values case (values 1) when 1 then true end"), "true");
        this.assertCompileError("42X39", "values case (values (1, 2)) when 1 then true end");
        CaseExpressionTest.assertStatementError("21000", statement, "values case (values 1, 2) when 1 then true end");
        this.assertCompileError("42818", "values case 1 when true then 'yes' end");
        this.assertCompileError("42818", "values case 1 when 1 then 'yes' when 2 then 'no' when 'three' then 'maybe' end");
        JDBC.assertSingleValueResultSet(statement.executeQuery("values case cast(1 as bigint) when cast(1 as smallint) then 'yes' end"), "yes");
        statement.execute("create sequence d1576_s start with 1");
        this.assertCompileError("42XAH", "values case next value for d1576_s when 1 then 1 else 0 end");
        this.assertCompileError("42XAH", "values case 1 when next value for d1576_s then 1 else 0 end");
        this.assertCompileError("42XAH", "values case 1 when 1 then next value for d1576_s else 0 end");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select case x when 1 then 1 else 0 end from (values next value for d1576_s) v(x)"), "1");
        statement.execute("drop sequence d1576_s restrict");
        JDBC.assertFullResultSet(statement.executeQuery("select case row_number() over () when 1 then 'one' when 2 then 'two' end from (values 1, 1, 1) v(x)"), new String[][]{{"one"}, {"two"}, {null}});
        PreparedStatement preparedStatement = this.prepareStatement("values case cast(? as integer) when 1 then 'one' when 2 then 'two' end");
        preparedStatement.setInt(1, 1);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "one");
        preparedStatement.setInt(1, 2);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "two");
        preparedStatement.setInt(1, 3);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        this.assertCompileError("42884", "values case cast(? as integer) when 1 then 1 when like 'abc' then 2 end");
        preparedStatement = this.prepareStatement("values case ? when 1 then 2 when 3 then 4 end");
        ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
        CaseExpressionTest.assertEquals((int)4, (int)parameterMetaData.getParameterType(1));
        CaseExpressionTest.assertEquals((int)1, (int)parameterMetaData.isNullable(1));
        preparedStatement.setInt(1, 1);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "2");
        preparedStatement.setInt(1, 2);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        preparedStatement.setInt(1, 3);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "4");
        preparedStatement = this.prepareStatement("values case ? when cast(1.1 as double) then true when cast(1.2 as double) then false end");
        parameterMetaData = preparedStatement.getParameterMetaData();
        CaseExpressionTest.assertEquals((int)8, (int)parameterMetaData.getParameterType(1));
        CaseExpressionTest.assertEquals((int)1, (int)parameterMetaData.isNullable(1));
        preparedStatement.setDouble(1, 1.1);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "true");
        preparedStatement.setDouble(1, 1.2);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "false");
        preparedStatement.setDouble(1, 1.3);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        preparedStatement = this.prepareStatement("values case ? when 1 then 'one' when 2.1 then 'two' end");
        parameterMetaData = preparedStatement.getParameterMetaData();
        CaseExpressionTest.assertEquals((int)3, (int)parameterMetaData.getParameterType(1));
        CaseExpressionTest.assertEquals((int)1, (int)parameterMetaData.isNullable(1));
        preparedStatement.setInt(1, 1);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "one");
        preparedStatement.setInt(1, 2);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        preparedStatement.setDouble(1, 1.1);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        preparedStatement.setDouble(1, 2.1);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "two");
        preparedStatement = this.prepareStatement("values case ? when 1 then 'one' when 2.1 then 'two' when cast(3 as bigint) then 'three' end");
        CaseExpressionTest.assertEquals((int)3, (int)parameterMetaData.getParameterType(1));
        CaseExpressionTest.assertEquals((int)1, (int)parameterMetaData.isNullable(1));
        preparedStatement.setInt(1, 1);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "one");
        preparedStatement.setInt(1, 2);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        preparedStatement.setInt(1, 3);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "three");
        preparedStatement.setDouble(1, 1.1);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        preparedStatement.setDouble(1, 2.1);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "two");
        preparedStatement.setDouble(1, 3.1);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        preparedStatement = this.prepareStatement("values case ? when 'abcdef' then 1 when cast('abcd' as varchar(4)) then 2 end");
        parameterMetaData = preparedStatement.getParameterMetaData();
        CaseExpressionTest.assertEquals((int)12, (int)parameterMetaData.getParameterType(1));
        CaseExpressionTest.assertEquals((int)6, (int)parameterMetaData.getPrecision(1));
        CaseExpressionTest.assertEquals((int)1, (int)parameterMetaData.isNullable(1));
        preparedStatement.setString(1, "abcdef");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "1");
        preparedStatement.setString(1, "abcd");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "2");
        preparedStatement.setString(1, "ab");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        preparedStatement.setString(1, "abcdefghi");
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        this.assertCompileError("42818", "values case ? when 1 then true when like 'abc' then false end");
        this.assertCompileError("42818", "values case ? when like 'abc' then true when 1 then false end");
        this.assertCompileError("42818", "values case ? when cast(x'abcd' as blob) then true end");
        this.assertCompileError("42818", "values case ? when cast('abcd' as clob) then true end");
        this.assertCompileError("42X35", "values case ? when ? then true end");
        this.assertCompileError("42X35", "values case ? when ? then true when 1 then false end");
        preparedStatement = this.prepareStatement("values (case +? when 1 then 1 when 2.1 then 2 end, case -? when 1 then 1 when 2.1 then 2 end)");
        parameterMetaData = preparedStatement.getParameterMetaData();
        CaseExpressionTest.assertEquals((int)3, (int)parameterMetaData.getParameterType(1));
        CaseExpressionTest.assertEquals((int)1, (int)parameterMetaData.isNullable(1));
        CaseExpressionTest.assertEquals((int)3, (int)parameterMetaData.getParameterType(2));
        CaseExpressionTest.assertEquals((int)1, (int)parameterMetaData.isNullable(2));
        preparedStatement.setInt(1, 1);
        preparedStatement.setInt(2, -1);
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), new String[][]{{"1", "1"}});
        preparedStatement.setInt(1, 2);
        preparedStatement.setInt(2, -2);
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), new String[][]{{null, null}});
        preparedStatement.setDouble(1, 1.1);
        preparedStatement.setDouble(2, -1.1);
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), new String[][]{{null, null}});
        preparedStatement.setDouble(1, 2.1);
        preparedStatement.setDouble(2, -2.1);
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), new String[][]{{"2", "2"}});
        preparedStatement = this.prepareStatement("values case 2*? when 2 then true when 3.0 then false end");
        parameterMetaData = preparedStatement.getParameterMetaData();
        CaseExpressionTest.assertEquals((int)4, (int)parameterMetaData.getParameterType(1));
        CaseExpressionTest.assertEquals((int)1, (int)parameterMetaData.isNullable(1));
        preparedStatement.setInt(1, 1);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "true");
        preparedStatement.setDouble(1, 1.5);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "true");
        preparedStatement.setInt(1, 2);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        preparedStatement = this.prepareStatement("values case 2.0*? when 2 then true when 3.0 then false end");
        parameterMetaData = preparedStatement.getParameterMetaData();
        CaseExpressionTest.assertEquals((int)3, (int)parameterMetaData.getParameterType(1));
        CaseExpressionTest.assertEquals((int)1, (int)parameterMetaData.isNullable(1));
        preparedStatement.setInt(1, 1);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "true");
        preparedStatement.setDouble(1, 1.5);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "false");
        preparedStatement.setInt(1, 2);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), null);
        JDBC.assertSingleValueResultSet(statement.executeQuery("values case true when exists(select * from sysibm.sysdummy1) then 1 end"), "1");
        this.assertCompileError("42818", "values case 1 when exists(select * from sysibm.sysdummy1) then 1 end");
        JDBC.assertSingleValueResultSet(statement.executeQuery("values case (select ibmreqd from sysibm.sysdummy1) when 'N' then 'no' when 'Y' then 'yes' end"), "yes");
        JDBC.assertSingleValueResultSet(statement.executeQuery("values case 'Y' when (select ibmreqd from sysibm.sysdummy1) then 'yes' end"), "yes");
        this.assertCompileError("42X39", "values case (select ibmreqd, 1 from sysibm.sysdummy1) when 'Y' then true end");
        this.assertCompileError("42X39", "values case 'Y' when (select ibmreqd, 1 from sysibm.sysdummy1) then true end");
        CaseExpressionTest.assertStatementError("21000", statement, "values case (select 1 from sys.systables) when 1 then true end");
        CaseExpressionTest.assertStatementError("21000", statement, "values case 1 when (select 1 from sys.systables) then true end");
        JDBC.assertSingleValueResultSet(statement.executeQuery("values case (select ibmreqd from sysibm.sysdummy1 where false) when is null then 'yes' end"), "yes");
        JDBC.assertSingleValueResultSet(statement.executeQuery("values case true when true then (select ibmreqd from sysibm.sysdummy1 where false) end"), null);
        JDBC.assertSingleValueResultSet(statement.executeQuery("select x from (values 1, 2, 3) v1(x) join (values 13, 14) v2(y) on case y-x when 10 then true end"), "3");
    }

    public void testSingleEvaluationOfCaseOperand() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create function count_me(x int) returns int language java parameter style java external name '" + ((Object)((Object)this)).getClass().getName() + ".countMe' no sql deterministic");
        callCount.set(0);
        JDBC.assertUnorderedResultSet(statement.executeQuery("select case count_me(x) when 1 then 'one' when 2 then 'two' when 3 then 'three' end from (values 1, 2, 3) v(x)"), new String[][]{{"one"}, {"two"}, {"three"}});
        CaseExpressionTest.assertEquals((int)3, (int)callCount.get());
    }

    public static int countMe(int n) {
        callCount.incrementAndGet();
        return n;
    }

    public void testLobAsCaseOperand() throws SQLException {
        Statement statement = this.createStatement();
        JDBC.assertSingleValueResultSet(statement.executeQuery("values case cast(null as blob) when is null then 'yes' end"), "yes");
        JDBC.assertSingleValueResultSet(statement.executeQuery("values case cast(null as clob) when is null then 'yes' end"), "yes");
        this.assertCompileError("42818", "values case cast(null as blob) when cast(null as blob) then true end");
        this.assertCompileError("42818", "values case cast(null as clob) when cast(null as clob) then true end");
        statement.execute("create table lobs_for_simple_case(id int generated always as identity, b blob, c clob)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into lobs_for_simple_case(b, c) values (?, ?)");
        preparedStatement.setBytes(1, new byte[]{1, 2, 3});
        preparedStatement.setString(2, "small");
        preparedStatement.executeUpdate();
        preparedStatement.setBinaryStream(1, new LoopingAlphabetStream(40000L));
        preparedStatement.setCharacterStream(2, new LoopingAlphabetReader(40000L));
        preparedStatement.executeUpdate();
        preparedStatement.setNull(1, 2004);
        preparedStatement.setNull(2, 2005);
        preparedStatement.executeUpdate();
        JDBC.assertUnorderedResultSet(statement.executeQuery("select id, case b when is null then 'yes' when is not null then 'no' end, case c when is null then 'yes' when like 'abc' then 'abc' when like 'abc%' then 'abc...' when is not null then 'no' end from lobs_for_simple_case"), new String[][]{{"1", "no", "no"}, {"2", "no", "abc..."}, {"3", "yes", "yes"}});
        statement.execute("drop table lobs_for_simple_case");
    }
}

