/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantilescommon;

import java.util.Comparator;
import java.util.Objects;
import org.apache.datasketches.common.SketchesArgumentException;

public final class GenericInequalitySearch {
    public static <T> int find(T[] arr, int low, int high, T v, Inequality crit, Comparator<T> comparator) {
        Objects.requireNonNull(arr, "Input arr must not be null");
        Objects.requireNonNull(v, "Input v must not be null");
        Objects.requireNonNull(crit, "Input inequality must not be null");
        Objects.requireNonNull(comparator, "Input comparator must not be null");
        if (arr.length == 0) {
            throw new SketchesArgumentException("Input array must not be empty.");
        }
        int lo = low;
        int hi = high;
        while (lo <= hi) {
            if (hi - lo <= 1) {
                return GenericInequalitySearch.resolve(arr, lo, hi, v, crit, comparator);
            }
            int mid = lo + (hi - lo) / 2;
            int ret = GenericInequalitySearch.compare(arr, mid, mid + 1, v, crit, comparator);
            if (ret == -1) {
                hi = mid;
                continue;
            }
            if (ret == 1) {
                lo = mid + 1;
                continue;
            }
            return GenericInequalitySearch.getIndex(arr, mid, mid + 1, v, crit, comparator);
        }
        return -1;
    }

    private static <T> int compare(T[] arr, int a, int b, T v, Inequality crit, Comparator<T> comparator) {
        int result = 0;
        switch (crit.ordinal()) {
            case 0: 
            case 3: {
                result = comparator.compare(v, arr[a]) <= 0 ? -1 : (comparator.compare(arr[b], v) < 0 ? 1 : 0);
                break;
            }
            case 1: 
            case 4: {
                result = comparator.compare(v, arr[a]) < 0 ? -1 : (comparator.compare(arr[b], v) <= 0 ? 1 : 0);
                break;
            }
            case 2: {
                result = comparator.compare(v, arr[a]) < 0 ? -1 : (comparator.compare(arr[b], v) < 0 ? 1 : 0);
            }
        }
        return result;
    }

    private static <T> int getIndex(T[] arr, int a, int b, T v, Inequality crit, Comparator<T> comparator) {
        int result = 0;
        switch (crit.ordinal()) {
            case 0: 
            case 1: {
                result = a;
                break;
            }
            case 3: 
            case 4: {
                result = b;
                break;
            }
            case 2: {
                result = comparator.compare(v, arr[a]) == 0 ? a : (comparator.compare(v, arr[b]) == 0 ? b : -1);
            }
        }
        return result;
    }

    private static <T> int resolve(T[] arr, int lo, int hi, T v, Inequality crit, Comparator<T> comparator) {
        int result = 0;
        switch (crit.ordinal()) {
            case 0: {
                result = lo == hi ? (comparator.compare(v, arr[lo]) > 0 ? lo : -1) : (comparator.compare(v, arr[hi]) > 0 ? hi : (comparator.compare(v, arr[lo]) > 0 ? lo : -1));
                break;
            }
            case 1: {
                result = lo == hi ? (comparator.compare(v, arr[lo]) >= 0 ? lo : -1) : (comparator.compare(v, arr[hi]) >= 0 ? hi : (comparator.compare(v, arr[lo]) >= 0 ? lo : -1));
                break;
            }
            case 2: {
                result = lo == hi ? (comparator.compare(v, arr[lo]) == 0 ? lo : -1) : (comparator.compare(v, arr[hi]) == 0 ? hi : (comparator.compare(v, arr[lo]) == 0 ? lo : -1));
                break;
            }
            case 3: {
                result = lo == hi ? (comparator.compare(v, arr[lo]) <= 0 ? lo : -1) : (comparator.compare(v, arr[lo]) <= 0 ? lo : (comparator.compare(v, arr[hi]) <= 0 ? hi : -1));
                break;
            }
            case 4: {
                result = lo == hi ? (comparator.compare(v, arr[lo]) < 0 ? lo : -1) : (comparator.compare(v, arr[lo]) < 0 ? lo : (comparator.compare(v, arr[hi]) < 0 ? hi : -1));
            }
        }
        return result;
    }

    public static enum Inequality {
        LT,
        LE,
        EQ,
        GE,
        GT;

    }
}

