/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantilescommon;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.quantilescommon.QuantilesUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

public class QuantilesUtilTest {
    private static final boolean enablePrinting = true;

    @Test
    public void checkEquallySpacedDoubles() {
        double[] arr = QuantilesUtil.equallySpacedDoubles((int)2);
        Assert.assertEquals((double)arr[1], (double)0.5);
        arr = QuantilesUtil.equallySpacedDoubles((int)4);
        Assert.assertEquals((double)arr[0], (double)0.0);
        Assert.assertEquals((double)arr[1], (double)0.25);
        Assert.assertEquals((double)arr[2], (double)0.5);
        Assert.assertEquals((double)arr[3], (double)0.75);
        Assert.assertEquals((double)arr[4], (double)1.0);
    }

    @Test
    public void checkEquallySpacedLongs() {
        long[] arr = QuantilesUtil.equallySpacedLongs((long)1L, (long)5L, (int)4);
        Assert.assertEquals((long)arr[0], (long)1L);
        Assert.assertEquals((long)arr[1], (long)2L);
        Assert.assertEquals((long)arr[2], (long)3L);
        Assert.assertEquals((long)arr[3], (long)4L);
        Assert.assertEquals((long)arr[4], (long)5L);
    }

    @Test
    public void checkEvenlySpacedFloats() {
        float[] arr = QuantilesUtil.evenlySpacedFloats((float)0.0f, (float)1.0f, (int)3);
        Assert.assertEquals((float)arr[0], (float)0.0f);
        Assert.assertEquals((float)arr[1], (float)0.5f);
        Assert.assertEquals((float)arr[2], (float)1.0f);
        arr = QuantilesUtil.evenlySpacedFloats((float)3.0f, (float)7.0f, (int)3);
        Assert.assertEquals((float)arr[0], (float)3.0f);
        Assert.assertEquals((float)arr[1], (float)5.0f);
        Assert.assertEquals((float)arr[2], (float)7.0f);
        arr = QuantilesUtil.evenlySpacedFloats((float)0.0f, (float)1.0f, (int)2);
        Assert.assertEquals((float)arr[0], (float)0.0f);
        Assert.assertEquals((float)arr[1], (float)1.0f);
        try {
            QuantilesUtil.evenlySpacedFloats((float)0.0f, (float)1.0f, (int)1);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkEvenlySpacedDoubles() {
        double[] arr = QuantilesUtil.evenlySpacedDoubles((double)0.0, (double)1.0, (int)3);
        Assert.assertEquals((double)arr[0], (double)0.0);
        Assert.assertEquals((double)arr[1], (double)0.5);
        Assert.assertEquals((double)arr[2], (double)1.0);
        arr = QuantilesUtil.evenlySpacedDoubles((double)3.0, (double)7.0, (int)3);
        Assert.assertEquals((double)arr[0], (double)3.0);
        Assert.assertEquals((double)arr[1], (double)5.0);
        Assert.assertEquals((double)arr[2], (double)7.0);
        arr = QuantilesUtil.evenlySpacedDoubles((double)0.0, (double)1.0, (int)2);
        Assert.assertEquals((double)arr[0], (double)0.0);
        Assert.assertEquals((double)arr[1], (double)1.0);
        try {
            QuantilesUtil.evenlySpacedDoubles((double)0.0, (double)1.0, (int)1);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkEvenlyLogSpaced() {
        double[] arr = QuantilesUtil.evenlyLogSpaced((double)1.0, (double)8.0, (int)4);
        Assert.assertEquals((double)arr[0], (double)1.0);
        Assert.assertEquals((double)arr[1], (double)2.0);
        Assert.assertEquals((double)arr[2], (double)4.0);
        Assert.assertEquals((double)arr[3], (double)8.0);
        try {
            QuantilesUtil.evenlyLogSpaced((double)-1.0, (double)1.0, (int)2);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            QuantilesUtil.evenlyLogSpaced((double)1.0, (double)-1.0, (int)2);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            QuantilesUtil.evenlyLogSpaced((double)-1.0, (double)-1.0, (int)2);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            QuantilesUtil.evenlyLogSpaced((double)1.0, (double)1.0, (int)1);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    static final void println(Object o) {
        System.out.println(o.toString());
    }
}

