/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.functions.UnparsedTextFunction;
import net.sf.saxon.ma.json.ParseJsonFn;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.z.IntPredicateProxy;
import net.sf.saxon.z.IntSetPredicate;

public class JsonBuilder {
    private Configuration config;
    private boolean liberal;

    protected JsonBuilder(Configuration config) {
        this.config = config;
    }

    public void setLiberal(boolean liberal) {
        this.liberal = liberal;
    }

    public boolean isLiberal() {
        return this.liberal;
    }

    public XdmValue parseJson(Reader jsonReader) throws SaxonApiException {
        try {
            XPathContextMajor context = new Controller(this.config).newXPathContext();
            IntPredicateProxy checker = IntSetPredicate.ALWAYS_TRUE;
            UnicodeString content = UnparsedTextFunction.readFile(checker, jsonReader);
            HashMap<String, GroundedValue> options = new HashMap<String, GroundedValue>();
            options.put("liberal", BooleanValue.get(this.liberal));
            options.put("escape", BooleanValue.TRUE);
            Item result = ParseJsonFn.parse(content.toString(), options, context);
            return XdmValue.wrap(result);
        }
        catch (IOException | XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public XdmValue parseJson(String json) throws SaxonApiException {
        return this.parseJson(new StringReader(json));
    }
}

