/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionCommitMessage;

public class SessionCommitMessage_V2
extends SessionCommitMessage {
    private long correlationID;

    @Override
    public long getCorrelationID() {
        return this.correlationID;
    }

    @Override
    public void setCorrelationID(long correlationID) {
        this.correlationID = correlationID;
    }

    @Override
    public boolean isResponseAsync() {
        return true;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        super.encodeRest(buffer);
        buffer.writeLong(this.correlationID);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        super.decodeRest(buffer);
        this.correlationID = buffer.readableBytes() >= 8 ? buffer.readLong() : -1L;
    }

    @Override
    public int expectedEncodeSize() {
        return super.expectedEncodeSize() + 8;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hashCode(this.correlationID);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionCommitMessage_V2)) {
            return false;
        }
        SessionCommitMessage_V2 other = (SessionCommitMessage_V2)obj;
        return this.correlationID == other.correlationID;
    }
}

