/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.actors;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.apache.activemq.artemis.utils.actors.OrderedExecutor;

public final class OrderedExecutorFactory
implements ExecutorFactory {
    final Executor parent;
    private boolean fair;

    public static boolean flushExecutor(Executor executor) {
        return OrderedExecutorFactory.flushExecutor(executor, 30L, TimeUnit.SECONDS);
    }

    public static boolean flushExecutor(Executor executor, long timeout, TimeUnit unit) {
        CountDownLatch latch = new CountDownLatch(1);
        executor.execute(latch::countDown);
        try {
            return latch.await(timeout, unit);
        }
        catch (Exception e) {
            return false;
        }
    }

    public OrderedExecutorFactory(Executor parent) {
        this.parent = parent;
    }

    @Override
    public ArtemisExecutor getExecutor() {
        return new OrderedExecutor(this.parent).setFair(this.fair);
    }

    public Executor getParent() {
        return this.parent;
    }

    public boolean isFair() {
        return this.fair;
    }

    public OrderedExecutorFactory setFair(boolean fair) {
        this.fair = fair;
        return this;
    }
}

