/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.artifact;

import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.artifact.BasicSAMLArtifactMapEntry;

public class ExpiringSAMLArtifactMapEntry
extends BasicSAMLArtifactMapEntry {
    @Nullable
    private Instant expiration;

    public ExpiringSAMLArtifactMapEntry(@Nonnull @NotEmpty String samlArtifact, @Nonnull @NotEmpty String issuerId, @Nonnull @NotEmpty String relyingPartyId, @Nonnull SAMLObject samlMessage) throws MarshallingException, UnmarshallingException {
        super(samlArtifact, issuerId, relyingPartyId, samlMessage);
    }

    @Nullable
    public Instant getExpiration() {
        return this.expiration;
    }

    public void setExpiration(@Nullable Instant exp) {
        this.expiration = exp;
    }

    public boolean isValid() {
        return this.isValid(Instant.now());
    }

    public boolean isValid(@Nonnull Instant effectiveTime) {
        if (this.expiration != null) {
            return this.expiration.isAfter(effectiveTime);
        }
        return true;
    }
}

