/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view;

import java.util.Map;
import java.util.TreeMap;

public enum ProducerField {
    ID("id"),
    NAME("name"),
    SESSION("session", "sessionID"),
    CONNECTION_ID("connectionID"),
    ADDRESS("address", "destination"),
    USER("user"),
    VALIDATED_USER("validatedUser"),
    PROTOCOL("protocol"),
    CLIENT_ID("clientID"),
    LOCAL_ADDRESS("localAddress"),
    REMOTE_ADDRESS("remoteAddress"),
    CREATION_TIME("creationTime"),
    MESSAGE_SENT("msgSent"),
    MESSAGE_SENT_SIZE("msgSizeSent"),
    LAST_PRODUCED_MESSAGE_ID("lastProducedMessageID");

    private static final Map<String, ProducerField> lookup;
    private final String name;
    private final String alternativeName;

    public String getName() {
        return this.name;
    }

    public String getAlternativeName() {
        return this.alternativeName;
    }

    private ProducerField(String name) {
        this(name, "");
    }

    private ProducerField(String name, String alternativeName) {
        this.name = name;
        this.alternativeName = alternativeName;
    }

    public static ProducerField valueOfName(String name) {
        return lookup.get(name);
    }

    static {
        lookup = new TreeMap<String, ProducerField>(String.CASE_INSENSITIVE_ORDER);
        for (ProducerField e : ProducerField.values()) {
            lookup.put(e.name, e);
        }
    }
}

