/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.transfer.validationtransformation;

import jakarta.annotation.Resource;
import jakarta.xml.ws.WebServiceContext;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.feature.transform.XSLTUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.ws.transfer.Representation;
import org.apache.cxf.ws.transfer.validationtransformation.ResourceTransformer;
import org.apache.cxf.ws.transfer.validationtransformation.ResourceValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XSLTResourceTransformer
implements ResourceTransformer {
    private static final Logger LOG = LogUtils.getL7dLogger(XSLTResourceTransformer.class);
    protected Templates templates;
    protected ResourceValidator validator;
    @Resource
    private WebServiceContext context;

    public XSLTResourceTransformer(Source xsl) {
        this(xsl, null);
    }

    public XSLTResourceTransformer(Source xsl, ResourceValidator validator) {
        this.validator = validator;
        try {
            this.templates = TransformerFactory.newInstance().newTemplates(xsl);
        }
        catch (TransformerConfigurationException e) {
            LOG.severe(e.getLocalizedMessage());
            throw new SoapFault("Internal error", this.getSoapVersion().getReceiver());
        }
    }

    @Override
    public ResourceValidator transform(Representation newRepresentation, Representation oldRepresentation) {
        Document doc = DOMUtils.createDocument();
        Node representation = (Node)newRepresentation.getAny();
        Node importedNode = doc.importNode(representation, true);
        doc.appendChild(importedNode);
        Document result = XSLTUtils.transform((Templates)this.templates, (Document)doc);
        newRepresentation.setAny(result.getDocumentElement());
        return this.validator;
    }

    private SoapVersion getSoapVersion() {
        WrappedMessageContext wmc = (WrappedMessageContext)this.context.getMessageContext();
        SoapMessage message = (SoapMessage)wmc.getWrappedMessage();
        return message.getVersion();
    }
}

