/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.websocket;

import java.io.IOException;
import java.lang.reflect.Constructor;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.util.SystemPropertyAction;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.cxf.transport.http.HttpDestinationFactory;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngineFactory;
import org.apache.cxf.transport.http_undertow.UndertowHTTPServerEngineFactory;
import org.apache.cxf.transport.websocket.atmosphere.AtmosphereWebSocketServletDestination;

@NoJSR250Annotations
public class WebSocketDestinationFactory
implements HttpDestinationFactory {
    private static final boolean ATMOSPHERE_AVAILABLE = WebSocketDestinationFactory.probeClass("org.atmosphere.cpr.ApplicationConfig");
    private static final boolean JETTY_AVAILABLE = WebSocketDestinationFactory.probeClass("org.apache.cxf.transport.http_jetty.JettyHTTPServerEngineFactory");
    private static final boolean UNDERTOW_AVAILABLE = WebSocketDestinationFactory.probeClass("org.apache.cxf.transport.http_undertow.UndertowHTTPServerEngineFactory");
    private static final Constructor<?> JETTY10_WEBSOCKET_DESTINATION_CTR = WebSocketDestinationFactory.probeConstructor("org.apache.cxf.transport.websocket.jetty10.Jetty10WebSocketDestination");
    private static final Constructor<?> UNDERTOW_WEBSOCKET_DESTINATION_CTR = WebSocketDestinationFactory.probeUndertowConstructor("org.apache.cxf.transport.websocket.undertow.UndertowWebSocketDestination");
    private static final Constructor<?> ATMOSPHERE_WEBSOCKET_JETTY_DESTINATION_CTR = WebSocketDestinationFactory.probeConstructor("org.apache.cxf.transport.websocket.atmosphere.AtmosphereWebSocketJettyDestination");
    private static final Constructor<?> ATMOSPHERE_WEBSOCKET_UNDERTOW_DESTINATION_CTR = WebSocketDestinationFactory.probeUndertowConstructor("org.apache.cxf.transport.websocket.atmosphere.AtmosphereWebSocketUndertowDestination");
    private final boolean atmosphereDisabled = Boolean.parseBoolean(SystemPropertyAction.getPropertyOrNull((String)"org.apache.cxf.transport.websocket.atmosphere.disabled"));

    private static boolean probeClass(String name) {
        try {
            Class.forName(name, true, WebSocketDestinationFactory.class.getClassLoader());
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static Constructor<?> probeConstructor(String name) {
        try {
            Class<?> clz = Class.forName(name, true, WebSocketDestinationFactory.class.getClassLoader());
            return clz.getConstructor(Bus.class, DestinationRegistry.class, EndpointInfo.class, JettyHTTPServerEngineFactory.class);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Constructor<?> probeUndertowConstructor(String name) {
        try {
            Class<?> clz = Class.forName(name, true, WebSocketDestinationFactory.class.getClassLoader());
            return clz.getConstructor(Bus.class, DestinationRegistry.class, EndpointInfo.class, UndertowHTTPServerEngineFactory.class);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public AbstractHTTPDestination createDestination(EndpointInfo endpointInfo, Bus bus, DestinationRegistry registry) throws IOException {
        if (endpointInfo.getAddress().startsWith("ws")) {
            if (ATMOSPHERE_AVAILABLE && !this.atmosphereDisabled) {
                if (JETTY_AVAILABLE) {
                    JettyHTTPServerEngineFactory serverEngineFactory = (JettyHTTPServerEngineFactory)bus.getExtension(JettyHTTPServerEngineFactory.class);
                    return this.createJettyHTTPDestination(ATMOSPHERE_WEBSOCKET_JETTY_DESTINATION_CTR, bus, registry, endpointInfo, serverEngineFactory);
                }
                if (UNDERTOW_AVAILABLE) {
                    UndertowHTTPServerEngineFactory undertowServerEngineFactory = (UndertowHTTPServerEngineFactory)bus.getExtension(UndertowHTTPServerEngineFactory.class);
                    return this.createUndertowHTTPDestination(ATMOSPHERE_WEBSOCKET_UNDERTOW_DESTINATION_CTR, bus, registry, endpointInfo, undertowServerEngineFactory);
                }
                return null;
            }
            if (JETTY_AVAILABLE) {
                JettyHTTPServerEngineFactory serverEngineFactory = (JettyHTTPServerEngineFactory)bus.getExtension(JettyHTTPServerEngineFactory.class);
                return this.createJettyHTTPDestination(JETTY10_WEBSOCKET_DESTINATION_CTR, bus, registry, endpointInfo, serverEngineFactory);
            }
            if (UNDERTOW_AVAILABLE) {
                UndertowHTTPServerEngineFactory undertowServerEngineFactory = (UndertowHTTPServerEngineFactory)bus.getExtension(UndertowHTTPServerEngineFactory.class);
                return this.createUndertowHTTPDestination(UNDERTOW_WEBSOCKET_DESTINATION_CTR, bus, registry, endpointInfo, undertowServerEngineFactory);
            }
            return null;
        }
        registry = WebSocketDestinationFactory.getDestinationRegistry(bus);
        if (ATMOSPHERE_AVAILABLE && !this.atmosphereDisabled) {
            return new AtmosphereWebSocketServletDestination(bus, registry, endpointInfo, endpointInfo.getAddress());
        }
        return this.createJettyHTTPDestination(JETTY10_WEBSOCKET_DESTINATION_CTR, bus, registry, endpointInfo, null);
    }

    private static DestinationRegistry getDestinationRegistry(Bus bus) {
        DestinationFactoryManager dfm = (DestinationFactoryManager)bus.getExtension(DestinationFactoryManager.class);
        try {
            DestinationFactory df = dfm.getDestinationFactory("http://cxf.apache.org/transports/http/configuration");
            if (df instanceof HTTPTransportFactory) {
                HTTPTransportFactory transportFactory = (HTTPTransportFactory)df;
                return transportFactory.getRegistry();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private AbstractHTTPDestination createJettyHTTPDestination(Constructor<?> ctr, Bus bus, DestinationRegistry registry, EndpointInfo ei, JettyHTTPServerEngineFactory jhsef) throws IOException {
        if (ctr != null) {
            try {
                return (AbstractHTTPDestination)ctr.newInstance(bus, registry, ei, jhsef);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return null;
    }

    private AbstractHTTPDestination createUndertowHTTPDestination(Constructor<?> ctr, Bus bus, DestinationRegistry registry, EndpointInfo ei, UndertowHTTPServerEngineFactory jhsef) throws IOException {
        if (ctr != null) {
            try {
                return (AbstractHTTPDestination)ctr.newInstance(bus, registry, ei, jhsef);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return null;
    }
}

