/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.jdbc.hsql;

import java.util.HashSet;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.jcs3.access.exception.CacheException;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;

public class HSQLDiskCacheUnitTest
extends TestCase {
    public void setUp() {
        JCS.setConfigFilename((String)"/TestHSQLDiskCache.ccf");
    }

    public void testBasicPutRemove() throws Exception {
        int i;
        int i2;
        int items = 20;
        String region = "testBasicPutRemove";
        CacheAccess jcs = JCS.getInstance((String)"testBasicPutRemove");
        for (i2 = 0; i2 <= 20; ++i2) {
            jcs.put((Object)(i2 + ":key"), (Object)("testBasicPutRemove data " + i2));
        }
        for (i2 = 0; i2 <= 20; ++i2) {
            String value = (String)jcs.get((Object)(i2 + ":key"));
            HSQLDiskCacheUnitTest.assertEquals((String)("key = [" + i2 + ":key] value = [" + value + "]"), (String)("testBasicPutRemove data " + i2), (String)value);
        }
        HashSet<String> keys = new HashSet<String>();
        for (int i3 = 0; i3 <= 20; ++i3) {
            keys.add(i3 + ":key");
        }
        Map elements = jcs.getCacheElements(keys);
        for (i = 0; i <= 20; ++i) {
            ICacheElement element = (ICacheElement)elements.get(i + ":key");
            HSQLDiskCacheUnitTest.assertNotNull((String)("element " + i + ":key is missing"), (Object)element);
            HSQLDiskCacheUnitTest.assertEquals((String)("value " + i + ":key"), (String)("testBasicPutRemove data " + i), (String)((String)element.getVal()));
        }
        for (i = 0; i <= 20; ++i) {
            jcs.remove((Object)(i + ":key"));
        }
        for (i = 0; i <= 20; ++i) {
            HSQLDiskCacheUnitTest.assertNull((String)("Removed key should be null: " + i + ":key"), (Object)jcs.get((Object)(i + ":key")));
        }
    }

    public void testRemoveAll() throws CacheException, InterruptedException {
        int i;
        String region = "removeAllAllowed";
        CacheAccess jcs = JCS.getInstance((String)"removeAllAllowed");
        int items = 20;
        for (i = 0; i <= 20; ++i) {
            jcs.put((Object)(i + ":key"), (Object)("removeAllAllowed data " + i));
        }
        jcs.clear();
        for (i = 0; i <= 20; ++i) {
            String value = (String)jcs.get((Object)(i + ":key"));
            HSQLDiskCacheUnitTest.assertNull((String)("value should be null key = [" + i + ":key] value = [" + value + "]"), (Object)value);
        }
    }

    public void testRemoveAllProhibition() throws CacheException, InterruptedException {
        int i;
        String region = "noRemoveAll";
        CacheAccess jcs = JCS.getInstance((String)"noRemoveAll");
        int items = 20;
        for (i = 0; i <= 20; ++i) {
            jcs.put((Object)(i + ":key"), (Object)("noRemoveAll data " + i));
        }
        jcs.clear();
        for (i = 0; i <= 20; ++i) {
            String value = (String)jcs.get((Object)(i + ":key"));
            HSQLDiskCacheUnitTest.assertEquals((String)("key = [" + i + ":key] value = [" + value + "]"), (String)("noRemoveAll data " + i), (String)value);
        }
    }
}

