/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.jcache.extras.writer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.cache.Cache;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.integration.CacheWriterException;
import org.apache.commons.jcs3.jcache.extras.InternalCacheRule;
import org.apache.commons.jcs3.jcache.extras.writer.CacheWriterAdapter;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class CacheWriterAdapterTest {
    @Rule
    public final InternalCacheRule rule = new InternalCacheRule(this);
    private final Map<String, String> copy = new HashMap<String, String>();
    private final Configuration<?, ?> config = new MutableConfiguration().setStoreByValue(false).setReadThrough(true).setCacheWriterFactory((Factory)new CacheWriterAdapter<String, String>(){

        public void write(Cache.Entry<? extends String, ? extends String> entry) throws CacheWriterException {
            CacheWriterAdapterTest.this.copy.put((String)entry.getKey(), (String)entry.getValue());
        }

        public void delete(Object key) throws CacheWriterException {
            CacheWriterAdapterTest.this.copy.remove(key);
        }
    });
    private Cache<String, String> cache;

    @Test
    public void checkWriteAllAndDeleteAll() {
        Assert.assertTrue((boolean)this.copy.isEmpty());
        Assert.assertFalse((boolean)this.cache.iterator().hasNext());
        this.cache.put((Object)"foo", (Object)"bar");
        Assert.assertEquals((long)1L, (long)this.copy.size());
        this.cache.remove((Object)"foo");
        Assert.assertTrue((boolean)this.copy.isEmpty());
        this.cache.putAll((Map)new HashMap<String, String>(){
            {
                this.put("a", "b");
                this.put("b", "c");
            }
        });
        Assert.assertEquals((long)2L, (long)this.copy.size());
        this.cache.removeAll(new HashSet<String>(Arrays.asList("a", "b")));
        Assert.assertTrue((boolean)this.copy.isEmpty());
    }
}

