/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.event;

import java.util.Collection;
import org.apache.commons.configuration.event.ConfigurationErrorEvent;
import org.apache.commons.configuration.event.ConfigurationErrorListener;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.apache.commons.configuration.event.EventSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestEventSource {
    static final int TEST_TYPE = 42;
    static final String TEST_PROPNAME = "test.property.name";
    static final Object TEST_PROPVALUE = "a test property value";
    CountingEventSource source;

    @Before
    public void setUp() throws Exception {
        this.source = new CountingEventSource();
    }

    @Test
    public void testInit() {
        Assert.assertTrue((String)"Listeners list is not empty", (boolean)this.source.getConfigurationListeners().isEmpty());
        Assert.assertFalse((String)"Removing listener", (boolean)this.source.removeConfigurationListener(new TestListener()));
        Assert.assertFalse((String)"Detail events are enabled", (boolean)this.source.isDetailEvents());
        Assert.assertTrue((String)"Error listeners list is not empty", (boolean)this.source.getErrorListeners().isEmpty());
    }

    @Test
    public void testAddConfigurationListener() {
        TestListener l = new TestListener();
        this.source.addConfigurationListener(l);
        Collection listeners = this.source.getConfigurationListeners();
        Assert.assertEquals((String)"Wrong number of listeners", (long)1L, (long)listeners.size());
        Assert.assertTrue((String)"Listener not in list", (boolean)listeners.contains(l));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddNullConfigurationListener() {
        this.source.addConfigurationListener(null);
    }

    @Test
    public void testRemoveConfigurationListener() {
        TestListener l = new TestListener();
        Assert.assertFalse((String)"Listener can be removed?", (boolean)this.source.removeConfigurationListener(l));
        this.source.addConfigurationListener(l);
        this.source.addConfigurationListener(new TestListener());
        Assert.assertFalse((String)"Unknown listener can be removed", (boolean)this.source.removeConfigurationListener(new TestListener()));
        Assert.assertTrue((String)"Could not remove listener", (boolean)this.source.removeConfigurationListener(l));
        Assert.assertFalse((String)"Listener still in list", (boolean)this.source.getConfigurationListeners().contains(l));
    }

    @Test
    public void testRemoveNullConfigurationListener() {
        this.source.addConfigurationListener(new TestListener());
        Assert.assertFalse((String)"Null listener can be removed", (boolean)this.source.removeConfigurationListener(null));
        Assert.assertEquals((String)"Listener list was modified", (long)1L, (long)this.source.getConfigurationListeners().size());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetConfigurationListenersUpdate() {
        this.source.addConfigurationListener(new TestListener());
        Collection list = this.source.getConfigurationListeners();
        list.clear();
    }

    @Test
    public void testGetConfigurationListenersAddNew() {
        Collection list = this.source.getConfigurationListeners();
        this.source.addConfigurationListener(new TestListener());
        Assert.assertTrue((String)"Listener snapshot not empty", (boolean)list.isEmpty());
    }

    @Test
    public void testSetDetailEvents() {
        this.source.setDetailEvents(true);
        Assert.assertTrue((String)"Detail events are disabled", (boolean)this.source.isDetailEvents());
        this.source.setDetailEvents(true);
        this.source.setDetailEvents(false);
        Assert.assertTrue((String)"Detail events are disabled again", (boolean)this.source.isDetailEvents());
        this.source.setDetailEvents(false);
        Assert.assertFalse((String)"Detail events are still enabled", (boolean)this.source.isDetailEvents());
    }

    @Test
    public void testFireEvent() {
        TestListener l = new TestListener();
        this.source.addConfigurationListener(l);
        this.source.fireEvent(42, TEST_PROPNAME, TEST_PROPVALUE, true);
        Assert.assertEquals((String)"Not 1 event created", (long)1L, (long)this.source.eventCount);
        Assert.assertEquals((String)"Listener not called once", (long)1L, (long)l.numberOfCalls);
        Assert.assertEquals((String)"Wrong event type", (long)42L, (long)l.lastEvent.getType());
        Assert.assertEquals((String)"Wrong property name", (Object)TEST_PROPNAME, (Object)l.lastEvent.getPropertyName());
        Assert.assertEquals((String)"Wrong property value", (Object)TEST_PROPVALUE, (Object)l.lastEvent.getPropertyValue());
        Assert.assertTrue((String)"Wrong before event flag", (boolean)l.lastEvent.isBeforeUpdate());
    }

    @Test
    public void testFireEventNoListeners() {
        this.source.fireEvent(42, TEST_PROPNAME, TEST_PROPVALUE, false);
        Assert.assertEquals((String)"An event object was created", (long)0L, (long)this.source.eventCount);
    }

    @Test
    public void testFireEventNoDetails() {
        TestListener l = new TestListener();
        this.source.addConfigurationListener(l);
        this.source.setDetailEvents(false);
        this.source.fireEvent(42, TEST_PROPNAME, TEST_PROPVALUE, false);
        Assert.assertEquals((String)"Event object was created", (long)0L, (long)this.source.eventCount);
        Assert.assertEquals((String)"Listener was called", (long)0L, (long)l.numberOfCalls);
    }

    @Test
    public void testRemoveListenerInFireEvent() {
        ConfigurationListener lstRemove = new ConfigurationListener(){

            public void configurationChanged(ConfigurationEvent event) {
                TestEventSource.this.source.removeConfigurationListener(this);
            }
        };
        this.source.addConfigurationListener(lstRemove);
        TestListener l = new TestListener();
        this.source.addConfigurationListener(l);
        this.source.fireEvent(42, TEST_PROPNAME, TEST_PROPVALUE, false);
        Assert.assertEquals((String)"Listener was not called", (long)1L, (long)l.numberOfCalls);
        Assert.assertEquals((String)"Listener was not removed", (long)1L, (long)this.source.getConfigurationListeners().size());
    }

    @Test
    public void testAddErrorListener() {
        TestListener l = new TestListener();
        this.source.addErrorListener(l);
        Collection listeners = this.source.getErrorListeners();
        Assert.assertEquals((String)"Wrong number of listeners", (long)1L, (long)listeners.size());
        Assert.assertTrue((String)"Listener not in list", (boolean)listeners.contains(l));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddNullErrorListener() {
        this.source.addErrorListener(null);
    }

    @Test
    public void testRemoveErrorListener() {
        TestListener l = new TestListener();
        Assert.assertFalse((String)"Listener can be removed?", (boolean)this.source.removeErrorListener(l));
        this.source.addErrorListener(l);
        this.source.addErrorListener(new TestListener());
        Assert.assertFalse((String)"Unknown listener can be removed", (boolean)this.source.removeErrorListener(new TestListener()));
        Assert.assertTrue((String)"Could not remove listener", (boolean)this.source.removeErrorListener(l));
        Assert.assertFalse((String)"Listener still in list", (boolean)this.source.getErrorListeners().contains(l));
    }

    @Test
    public void testRemoveNullErrorListener() {
        this.source.addErrorListener(new TestListener());
        Assert.assertFalse((String)"Null listener can be removed", (boolean)this.source.removeErrorListener(null));
        Assert.assertEquals((String)"Listener list was modified", (long)1L, (long)this.source.getErrorListeners().size());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetErrorListenersUpdate() {
        this.source.addErrorListener(new TestListener());
        Collection list = this.source.getErrorListeners();
        list.clear();
    }

    @Test
    public void testFireError() {
        TestListener l = new TestListener();
        this.source.addErrorListener(l);
        Exception testException = new Exception("A test");
        this.source.fireError(42, TEST_PROPNAME, TEST_PROPVALUE, testException);
        Assert.assertEquals((String)"Not 1 event created", (long)1L, (long)this.source.errorCount);
        Assert.assertEquals((String)"Error listener not called once", (long)1L, (long)l.numberOfErrors);
        Assert.assertEquals((String)"Normal event was generated", (long)0L, (long)l.numberOfCalls);
        Assert.assertEquals((String)"Wrong event type", (long)42L, (long)l.lastEvent.getType());
        Assert.assertEquals((String)"Wrong property name", (Object)TEST_PROPNAME, (Object)l.lastEvent.getPropertyName());
        Assert.assertEquals((String)"Wrong property value", (Object)TEST_PROPVALUE, (Object)l.lastEvent.getPropertyValue());
        Assert.assertEquals((String)"Wrong Throwable object", (Object)testException, (Object)((ConfigurationErrorEvent)l.lastEvent).getCause());
    }

    @Test
    public void testFireErrorNoListeners() {
        this.source.fireError(42, TEST_PROPNAME, TEST_PROPVALUE, new Exception());
        Assert.assertEquals((String)"An error event object was created", (long)0L, (long)this.source.errorCount);
    }

    @Test
    public void testClone() throws CloneNotSupportedException {
        this.source.addConfigurationListener(new TestListener());
        this.source.addErrorListener(new TestListener());
        EventSource copy = (EventSource)this.source.clone();
        Assert.assertTrue((String)"Configuration listeners registered for clone", (boolean)copy.getConfigurationListeners().isEmpty());
        Assert.assertTrue((String)"Error listeners registered for clone", (boolean)copy.getErrorListeners().isEmpty());
    }

    static class CountingEventSource
    extends EventSource
    implements Cloneable {
        int eventCount;
        int errorCount;

        CountingEventSource() {
        }

        protected ConfigurationEvent createEvent(int type, String propName, Object propValue, boolean before) {
            ++this.eventCount;
            return super.createEvent(type, propName, propValue, before);
        }

        protected ConfigurationErrorEvent createErrorEvent(int type, String propName, Object value, Throwable ex) {
            ++this.errorCount;
            return super.createErrorEvent(type, propName, value, ex);
        }
    }

    static class TestListener
    implements ConfigurationListener,
    ConfigurationErrorListener {
        ConfigurationEvent lastEvent;
        int numberOfCalls;
        int numberOfErrors;

        TestListener() {
        }

        public void configurationChanged(ConfigurationEvent event) {
            this.lastEvent = event;
            ++this.numberOfCalls;
        }

        public void configurationError(ConfigurationErrorEvent event) {
            this.lastEvent = event;
            ++this.numberOfErrors;
        }
    }
}

