/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.Converter;
import org.apache.commons.beanutils2.converters.AbstractNumberConverterTest;
import org.apache.commons.beanutils2.converters.ShortConverter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ShortConverterTest
extends AbstractNumberConverterTest<Short> {
    private ShortConverter converter;

    @Override
    protected Class<Short> getExpectedType() {
        return Short.class;
    }

    protected ShortConverter makeConverter() {
        return new ShortConverter();
    }

    protected ShortConverter makeConverter(Short defaultValue) {
        return new ShortConverter(defaultValue);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.converter = this.makeConverter();
        this.numbers[0] = Short.valueOf("-12");
        this.numbers[1] = Short.valueOf("13");
        this.numbers[2] = Short.valueOf("-22");
        this.numbers[3] = Short.valueOf("23");
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.converter = null;
    }

    @Test
    public void testInvalidAmount() {
        ShortConverter converter = this.makeConverter();
        Class<Short> clazz = Short.class;
        Long min = -32768L;
        Long max = 32767L;
        Long minMinusOne = min - 1L;
        Long maxPlusOne = max + 1L;
        Assertions.assertEquals((Object)Short.MIN_VALUE, (Object)converter.convert(clazz, (Object)min), (String)"Minimum");
        Assertions.assertEquals((Object)Short.MAX_VALUE, (Object)converter.convert(clazz, (Object)max), (String)"Maximum");
        Assertions.assertThrows(ConversionException.class, () -> ShortConverterTest.lambda$testInvalidAmount$0((Converter)converter, clazz, minMinusOne), (String)"Less than minimum, expected ConversionException");
        Assertions.assertThrows(ConversionException.class, () -> ShortConverterTest.lambda$testInvalidAmount$1((Converter)converter, clazz, maxPlusOne), (String)"More than maximum, expected ConversionException");
    }

    @Test
    public void testSimpleConversion() throws Exception {
        String[] message = new String[]{"from String", "from String", "from String", "from String", "from String", "from String", "from String", "from Byte", "from Short", "from Integer", "from Long", "from Float", "from Double"};
        Object[] input = new Object[]{String.valueOf(Short.MIN_VALUE), "-17", "-1", "0", "1", "17", String.valueOf(Short.MAX_VALUE), (byte)7, (short)8, 9, 10L, Float.valueOf(11.1f), 12.2};
        Short[] expected = new Short[]{(short)Short.MIN_VALUE, (short)-17, (short)-1, (short)0, (short)1, (short)17, (short)Short.MAX_VALUE, (short)7, (short)8, (short)9, (short)10, (short)11, (short)12};
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Short)expected[i], (Short)((Short)this.converter.convert(Short.class, input[i])), (String)(message[i] + " to Short"));
            Assertions.assertEquals((Short)expected[i], (Short)((Short)this.converter.convert(Short.TYPE, input[i])), (String)(message[i] + " to short"));
            Assertions.assertEquals((Short)expected[i], (Short)((Short)this.converter.convert(null, input[i])), (String)(message[i] + " to null type"));
        }
    }

    private static /* synthetic */ void lambda$testInvalidAmount$1(Converter converter, Class clazz, Long maxPlusOne) throws Throwable {
        converter.convert(clazz, (Object)maxPlusOne);
    }

    private static /* synthetic */ void lambda$testInvalidAmount$0(Converter converter, Class clazz, Long minMinusOne) throws Throwable {
        converter.convert(clazz, (Object)minMinusOne);
    }
}

