// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

export default {
  primaryColor: '#39A7DE', // primary color of ant design
  navTheme: 'light', // theme for nav menu
  layout: 'sidemenu', // nav menu position: sidemenu or topmenu
  contentWidth: 'Fixed', // layout of content: Fluid or Fixed, only works when layout is topmenu
  fixedHeader: true, // sticky header
  fixSiderbar: true, // sticky siderbar
  autoHideHeader: false, //  auto hide header
  invertedMode: true,
  multiTab: false, // enable to have tab/route history stuff
  // vue-ls options
  // storageOptions: {
  //   namespace: 'primate__', // key prefix
  //   name: 'ls', // name variable Vue.[ls] or this.[$ls],
  //   storage: 'local' // storage name session, local, memory
  // },
  // vue-ls options
  storageOptions: {
    prefix: 'primate__', // key prefix
    drivers: ['local'] // storage name session, local, memory
  }
}
