/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class PanelFactory {
    public static JPanel createButtonPanel(JButton[] buttons) {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(3, 20, 3, 7));
        panel.setLayout(new FlowLayout(2));
        for (JButton button : buttons) {
            panel.add(button);
        }
        return panel;
    }

    public static JPanel createForm(String title, String[] labels, Component[] components) {
        Component[] jlabels = new Component[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            jlabels[i] = new JLabel(labels[i]);
        }
        return PanelFactory.createForm(title, jlabels, components);
    }

    public static JPanel createForm(Component[] leftComponents, Component[] rightComponents) {
        return PanelFactory.createForm(null, leftComponents, rightComponents);
    }

    public static JPanel createForm(String title, Component[] leftComponents, Component[] rightComponents) {
        if (leftComponents.length != rightComponents.length) {
            throw new IllegalArgumentException("Arrays must be the same size, instead got " + leftComponents.length + "and " + rightComponents.length);
        }
        int numRows = leftComponents.length;
        if (numRows == 0) {
            throw new IllegalArgumentException("Zero components.");
        }
        FormLayout layout = new FormLayout("right:100, 3dlu, left:300", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        if (title != null) {
            builder.appendSeparator(title);
        }
        for (int i = 0; i < numRows; ++i) {
            builder.append(leftComponents[i], rightComponents[i]);
            builder.nextLine();
        }
        return builder.getPanel();
    }

    public static JPanel createTablePanel(final JTable table, JButton[] buttons) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(5, 5));
        table.setSelectionMode(2);
        table.setAutoResizeMode(0);
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (table.isEditing()) {
                    table.getCellEditor().stopCellEditing();
                }
            }
        });
        panel.add((Component)scrollPane, "Center");
        if (buttons != null) {
            panel.add((Component)PanelFactory.createButtonPanel(buttons), "South");
        }
        return panel;
    }

    public static JPanel createTablePanel(JTable table, JComponent[] components, JButton[] buttons) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(5, 5));
        JPanel temp_panel = new JPanel(new BorderLayout());
        table.getSelectionModel().setSelectionMode(0);
        table.setAutoResizeMode(0);
        JScrollPane scroll_pane = new JScrollPane(table);
        temp_panel.add((Component)scroll_pane, "Center");
        for (JComponent component : components) {
            JPanel temp = new JPanel(new BorderLayout());
            temp.add((Component)temp_panel, "Center");
            temp.add((Component)component, "South");
            temp_panel = temp;
        }
        panel.add((Component)temp_panel, "Center");
        if (buttons != null) {
            panel.add((Component)PanelFactory.createButtonPanel(buttons), "South");
        }
        return panel;
    }
}

