/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import java.util.Optional;
import org.apache.cayenne.access.translator.select.PathProcessor;
import org.apache.cayenne.access.translator.select.PathTranslationResult;
import org.apache.cayenne.access.translator.select.TranslatorContext;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddedAttribute;
import org.apache.cayenne.map.JoinType;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;

class ObjPathProcessor
extends PathProcessor<ObjEntity> {
    private ObjAttribute attribute;
    private EmbeddedAttribute embeddedAttribute;

    ObjPathProcessor(TranslatorContext context, ObjEntity entity, String parentPath) {
        super(context, entity);
        if (parentPath != null) {
            this.currentDbPath.append(parentPath);
        }
    }

    ObjAttribute getAttribute() {
        return this.attribute;
    }

    @Override
    protected void processNormalAttribute(String next) {
        this.attribute = this.fetchAttribute(next);
        if (this.attribute != null) {
            this.processAttribute(this.attribute);
            return;
        }
        ObjRelationship relationship = ((ObjEntity)this.entity).getRelationship(next);
        if (relationship != null) {
            this.processRelationship(relationship);
            return;
        }
        throw new IllegalStateException("Unable to resolve path: " + this.currentDbPath.toString() + " (unknown '" + next + "' component)");
    }

    @Override
    protected void processAliasedAttribute(String next, String alias) {
        ObjRelationship relationship = ((ObjEntity)this.entity).getRelationship(alias);
        if (relationship == null) {
            throw new IllegalStateException("Non-relationship aliased path part: " + alias);
        }
        this.pathSplitAliases.put("db:" + next, relationship.getDbRelationshipPath());
        this.processRelationship(relationship);
    }

    protected ObjAttribute fetchAttribute(String name) {
        if (this.embeddedAttribute != null) {
            ObjAttribute attribute = this.embeddedAttribute.getAttribute(name);
            this.embeddedAttribute = null;
            return attribute;
        }
        return ((ObjEntity)this.entity).getAttribute(name);
    }

    protected void processAttribute(ObjAttribute attribute) {
        if (attribute instanceof EmbeddedAttribute) {
            this.embeddedAttribute = (EmbeddedAttribute)attribute;
            if (this.lastComponent) {
                this.embeddedAttribute.getAttributes().forEach(a -> {
                    int len = this.currentDbPath.length();
                    this.processAttribute((ObjAttribute)a);
                    this.currentDbPath.delete(len, this.currentDbPath.length());
                });
            }
            return;
        }
        PathTranslationResult result = this.context.getPathTranslator().translatePath(((ObjEntity)this.entity).getDbEntity(), attribute.getDbAttributePath(), this.currentDbPath.toString(), attribute.isFlattened());
        this.attributes.addAll(result.getDbAttributes());
        this.attributePaths.addAll(result.getAttributePaths());
        this.relationship = result.getDbRelationship().orElse(this.relationship);
        this.currentDbPath.delete(0, this.currentDbPath.length());
        this.currentDbPath.append(result.getFinalPath());
    }

    protected void processRelationship(ObjRelationship relationship) {
        if (this.lastComponent) {
            this.processRelTermination(relationship);
        } else {
            this.entity = relationship.getTargetEntity();
            int count = relationship.getDbRelationships().size();
            for (int i = 0; i < count; ++i) {
                DbRelationship dbRel = relationship.getDbRelationships().get(i);
                this.appendCurrentPath(dbRel.getName());
                boolean leftJoin = this.isOuterJoin() || count > 1;
                this.context.getTableTree().addJoinTable(this.currentDbPath.toString(), dbRel, leftJoin ? JoinType.LEFT_OUTER : JoinType.INNER);
            }
        }
    }

    protected void processRelTermination(ObjRelationship relationship) {
        String path;
        String string = path = this.currentAlias != null ? "db:" + this.currentAlias : relationship.getDbRelationshipPath();
        if (this.isOuterJoin()) {
            path = path + '+';
        }
        PathTranslationResult result = this.context.getPathTranslator().translatePath(((ObjEntity)this.entity).getDbEntity(), path, this.currentDbPath.toString(), relationship.isFlattened());
        this.attributes.addAll(result.getDbAttributes());
        this.attributePaths.addAll(result.getAttributePaths());
        this.relationship = result.getDbRelationship().orElse(this.relationship);
        this.currentDbPath.delete(0, this.currentDbPath.length());
        this.currentDbPath.append(result.getFinalPath());
    }

    @Override
    public Optional<Embeddable> getEmbeddable() {
        if (this.embeddedAttribute != null) {
            return Optional.of(this.embeddedAttribute.getEmbeddable());
        }
        return Optional.empty();
    }
}

