/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import javax.sql.DataSource;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.server.DataSourceFactory;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.conn.PoolManager;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.resource.ResourceLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XMLPoolingDataSourceFactory
implements DataSourceFactory {
    private static final Log logger = LogFactory.getLog(XMLPoolingDataSourceFactory.class);
    @Inject
    protected ResourceLocator resourceLocator;
    @Inject
    protected JdbcEventLogger jdbcEventLogger;

    public DataSource getDataSource(DataNodeDescriptor nodeDescriptor) throws Exception {
        DataSourceInfo dataSourceDescriptor = nodeDescriptor.getDataSourceDescriptor();
        if (dataSourceDescriptor == null) {
            String message = "Null dataSourceDescriptor for nodeDescriptor '" + nodeDescriptor.getName() + "'";
            logger.info((Object)message);
            throw new ConfigurationException(message, new Object[0]);
        }
        try {
            return new PoolManager(dataSourceDescriptor.getJdbcDriver(), dataSourceDescriptor.getDataSourceUrl(), dataSourceDescriptor.getMinConnections(), dataSourceDescriptor.getMaxConnections(), dataSourceDescriptor.getUserName(), dataSourceDescriptor.getPassword(), this.jdbcEventLogger);
        }
        catch (Exception e) {
            this.jdbcEventLogger.logConnectFailure(e);
            throw e;
        }
    }
}

