/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.ActionManager;
import org.apache.cayenne.modeler.action.RemoveAttributeAction;
import org.apache.cayenne.modeler.action.RemoveCallbackMethodAction;
import org.apache.cayenne.modeler.action.RemoveRelationshipAction;
import org.apache.cayenne.modeler.editor.AbstractCallbackMethodsTab;
import org.apache.cayenne.modeler.editor.ExistingSelectionProcessor;
import org.apache.cayenne.modeler.editor.ObjEntityAttributeTab;
import org.apache.cayenne.modeler.editor.ObjEntityCallbackListenersTab;
import org.apache.cayenne.modeler.editor.ObjEntityCallbackMethodsTab;
import org.apache.cayenne.modeler.editor.ObjEntityRelationshipTab;
import org.apache.cayenne.modeler.editor.ObjEntityTab;
import org.apache.cayenne.modeler.event.AttributeDisplayEvent;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.ObjAttributeDisplayListener;
import org.apache.cayenne.modeler.event.ObjEntityDisplayListener;
import org.apache.cayenne.modeler.event.ObjRelationshipDisplayListener;
import org.apache.cayenne.modeler.event.RelationshipDisplayEvent;

public class ObjEntityTabbedView
extends JTabbedPane
implements ObjEntityDisplayListener,
ObjRelationshipDisplayListener,
ObjAttributeDisplayListener {
    protected ProjectController mediator;
    protected Component entityPanel;
    protected ObjEntityRelationshipTab relationshipsPanel;
    protected ObjEntityAttributeTab attributesPanel;
    protected AbstractCallbackMethodsTab callbacksPanel;
    protected JPanel listenersPanel;

    public ObjEntityTabbedView(ProjectController mediator) {
        this.mediator = mediator;
        this.initView();
        this.initController();
    }

    private void initView() {
        this.setTabPlacement(1);
        this.entityPanel = new JScrollPane(new ObjEntityTab(this.mediator));
        this.addTab("Entity", this.entityPanel);
        this.attributesPanel = new ObjEntityAttributeTab(this.mediator);
        this.addTab("Attributes", this.attributesPanel);
        this.relationshipsPanel = new ObjEntityRelationshipTab(this.mediator);
        this.addTab("Relationships", this.relationshipsPanel);
        this.callbacksPanel = new ObjEntityCallbackMethodsTab(this.mediator);
        this.addTab("Callbacks", this.callbacksPanel);
        this.listenersPanel = new ObjEntityCallbackListenersTab(this.mediator);
        this.addTab("Listeners", this.listenersPanel);
    }

    private void initController() {
        this.mediator.addObjEntityDisplayListener(this);
        this.mediator.addObjAttributeDisplayListener(this);
        this.mediator.addObjRelationshipDisplayListener(this);
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ObjEntityTabbedView.this.resetRemoveButtons();
                Component selected = ObjEntityTabbedView.this.getSelectedComponent();
                while (selected instanceof JScrollPane) {
                    selected = ((JScrollPane)selected).getViewport().getView();
                }
                if (selected instanceof ExistingSelectionProcessor) {
                    ((ExistingSelectionProcessor)((Object)selected)).processExistingSelection(e);
                }
            }
        });
    }

    private void resetRemoveButtons() {
        ActionManager actionManager = Application.getInstance().getActionManager();
        actionManager.getAction(RemoveAttributeAction.class).setEnabled(false);
        actionManager.getAction(RemoveRelationshipAction.class).setEnabled(false);
        actionManager.getAction(RemoveCallbackMethodAction.class).setEnabled(false);
    }

    public void currentObjEntityChanged(EntityDisplayEvent e) {
        Entity entity = e.getEntity();
        if (e.isMainTabFocus() && entity instanceof ObjEntity && this.getSelectedComponent() != this.entityPanel) {
            this.setSelectedComponent(this.entityPanel);
            this.entityPanel.setVisible(true);
        }
        this.resetRemoveButtons();
        this.setVisible(e.getEntity() != null);
    }

    public void currentObjRelationshipChanged(RelationshipDisplayEvent e) {
        if (e.getEntity() == null) {
            return;
        }
        Relationship[] rels = e.getRelationships();
        ObjRelationship[] objRels = new ObjRelationship[rels.length];
        System.arraycopy(rels, 0, objRels, 0, rels.length);
        if (this.getSelectedComponent() != this.relationshipsPanel && objRels.length > 0) {
            this.setSelectedComponent(this.relationshipsPanel);
            this.relationshipsPanel.setVisible(true);
        }
        this.relationshipsPanel.selectRelationships(objRels);
    }

    public void currentObjAttributeChanged(AttributeDisplayEvent e) {
        if (e.getEntity() == null) {
            return;
        }
        Attribute[] attrs = e.getAttributes();
        ObjAttribute[] objAttrs = new ObjAttribute[attrs.length];
        System.arraycopy(attrs, 0, objAttrs, 0, attrs.length);
        if (this.getSelectedComponent() != this.attributesPanel && objAttrs.length > 0) {
            this.setSelectedComponent(this.attributesPanel);
            this.attributesPanel.setVisible(true);
        }
        this.attributesPanel.selectAttributes(objAttrs);
    }
}

