/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.UUID;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.types.ExtendedType;

public class UUIDType
implements ExtendedType {
    public String getClassName() {
        return UUID.class.getName();
    }

    public Object materializeObject(ResultSet rs, int index, int type) throws Exception {
        String uuid = rs.getString(index);
        if (uuid == null) {
            return null;
        }
        try {
            return UUID.fromString(uuid);
        }
        catch (IllegalArgumentException e) {
            throw new CayenneRuntimeException("Invalid UUID value: " + uuid, (Throwable)e, new Object[0]);
        }
    }

    public Object materializeObject(CallableStatement rs, int index, int type) throws Exception {
        String uuid = rs.getString(index);
        if (uuid == null) {
            return null;
        }
        try {
            return UUID.fromString(uuid);
        }
        catch (IllegalArgumentException e) {
            throw new CayenneRuntimeException("Invalid UUID value: " + uuid, (Throwable)e, new Object[0]);
        }
    }

    public void setJdbcObject(PreparedStatement statement, Object value, int pos, int type, int scale) throws Exception {
        if (value == null) {
            statement.setNull(pos, type);
        } else if (value instanceof UUID) {
            statement.setObject(pos, (Object)value.toString(), type);
        } else {
            throw new IllegalArgumentException("Expected java.util.UUID, got " + value.getClass().getName());
        }
    }
}

