/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.common.ExtBasicArrowButtonHandler;
import com.jgoodies.looks.common.ExtBasicSpinnerLayout;
import com.jgoodies.looks.windows.WindowsArrowButton;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;

public final class WindowsSpinnerUI
extends com.sun.java.swing.plaf.windows.WindowsSpinnerUI {
    private static final Border EMPTY_BORDER = new BorderUIResource(new EmptyBorder(2, 2, 2, 2));
    private static final ExtBasicArrowButtonHandler nextButtonHandler = new ExtBasicArrowButtonHandler("increment", true);
    private static final ExtBasicArrowButtonHandler previousButtonHandler = new ExtBasicArrowButtonHandler("decrement", false);

    public static ComponentUI createUI(JComponent b) {
        return new WindowsSpinnerUI();
    }

    protected Component createPreviousButton() {
        if (LookUtils.IS_LAF_WINDOWS_XP_ENABLED) {
            return super.createPreviousButton();
        }
        WindowsArrowButton b = new WindowsArrowButton(5);
        b.addActionListener(previousButtonHandler);
        b.addMouseListener(previousButtonHandler);
        return b;
    }

    protected Component createNextButton() {
        if (LookUtils.IS_LAF_WINDOWS_XP_ENABLED) {
            return super.createNextButton();
        }
        WindowsArrowButton b = new WindowsArrowButton(1);
        b.addActionListener(nextButtonHandler);
        b.addMouseListener(nextButtonHandler);
        return b;
    }

    protected JComponent createEditor() {
        JComponent editor = this.spinner.getEditor();
        this.configureEditor(editor);
        return editor;
    }

    protected LayoutManager createLayout() {
        return new ExtBasicSpinnerLayout();
    }

    protected void replaceEditor(JComponent oldEditor, JComponent newEditor) {
        this.spinner.remove(oldEditor);
        this.configureEditor(newEditor);
        this.spinner.add((Component)newEditor, "Editor");
    }

    private void configureEditor(JComponent editor) {
        if (editor instanceof JSpinner.DefaultEditor) {
            JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)editor;
            defaultEditor.getTextField().setBorder(EMPTY_BORDER);
        }
    }
}

