/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.modules;

import com.google.inject.AbstractModule;
import com.google.inject.multibindings.ProvidesIntoMap;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import org.apache.cassandra.sidecar.cluster.InstancesMetadata;
import org.apache.cassandra.sidecar.common.response.HealthResponse;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.handlers.CassandraHealthHandler;
import org.apache.cassandra.sidecar.handlers.GossipHealthHandler;
import org.apache.cassandra.sidecar.metrics.SidecarMetrics;
import org.apache.cassandra.sidecar.modules.ApiModule;
import org.apache.cassandra.sidecar.modules.multibindings.KeyClassMapKey;
import org.apache.cassandra.sidecar.modules.multibindings.PeriodicTaskMapKeys;
import org.apache.cassandra.sidecar.modules.multibindings.VertxRouteMapKeys;
import org.apache.cassandra.sidecar.routes.RouteBuilder;
import org.apache.cassandra.sidecar.routes.VertxRoute;
import org.apache.cassandra.sidecar.tasks.HealthCheckPeriodicTask;
import org.apache.cassandra.sidecar.tasks.PeriodicTask;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;

@Path(value="/")
public class HealthCheckModule
extends AbstractModule {
    @ProvidesIntoMap
    @KeyClassMapKey(value=PeriodicTaskMapKeys.HealthCheckPeriodicTaskKey.class)
    PeriodicTask healthCheckPeriodicTask(SidecarConfiguration configuration, InstancesMetadata instancesMetadata, ExecutorPools executorPools, SidecarMetrics metrics) {
        return new HealthCheckPeriodicTask(configuration, instancesMetadata, executorPools, metrics);
    }

    @GET
    @Path(value="/api/v1/__health")
    @Operation(summary="Check Sidecar health", description="Returns the health status of the Sidecar application")
    @APIResponse(description="Sidecar is healthy", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=HealthResponse.class))})
    @ProvidesIntoMap
    @KeyClassMapKey(value=VertxRouteMapKeys.SidecarHealthRouteKey.class)
    VertxRoute sidecarHealthRoute(RouteBuilder.Factory factory) {
        return factory.builderForUnauthorizedRoute().handler((Handler<RoutingContext>)((Handler)context -> context.json(ApiModule.OK_STATUS))).build();
    }

    @Deprecated
    @GET
    @Path(value="/api/v1/cassandra/__health")
    @Operation(summary="Check Cassandra health", description="Returns the overall health status of the Cassandra node")
    @APIResponses(value={@APIResponse(description="Cassandra is healthy", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=HealthResponse.class))}), @APIResponse(responseCode="503", description="Cassandra is unhealthy", content={@Content(mediaType="application/json", schema=@Schema(implementation=HealthResponse.class))})})
    @ProvidesIntoMap
    @KeyClassMapKey(value=VertxRouteMapKeys.CassandraHealthRouteKey.class)
    VertxRoute cassandraHealthRoute(RouteBuilder.Factory factory, CassandraHealthHandler cassandraHealthHandler) {
        return factory.builderForUnauthorizedRoute().handler(cassandraHealthHandler).build();
    }

    @GET
    @Path(value="/api/v1/cassandra/native/__health")
    @Operation(summary="Check Cassandra native protocol health", description="Returns the health status of Cassandra's native protocol interface")
    @APIResponses(value={@APIResponse(description="Cassandra native protocol is healthy", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=HealthResponse.class))}), @APIResponse(responseCode="503", description="Cassandra native protocol is unhealthy", content={@Content(mediaType="application/json", schema=@Schema(implementation=HealthResponse.class))})})
    @ProvidesIntoMap
    @KeyClassMapKey(value=VertxRouteMapKeys.CassandraNativeHealthRouteKey.class)
    VertxRoute cassandraNativeHealthRoute(RouteBuilder.Factory factory, CassandraHealthHandler cassandraHealthHandler) {
        return factory.builderForUnauthorizedRoute().handler(cassandraHealthHandler).build();
    }

    @GET
    @Path(value="/api/v1/cassandra/jmx/__health")
    @Operation(summary="Check Cassandra JMX health", description="Returns the health status of Cassandra's JMX interface")
    @APIResponses(value={@APIResponse(description="Cassandra JMX is healthy", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=HealthResponse.class))}), @APIResponse(responseCode="503", description="Cassandra JMX is unhealthy", content={@Content(mediaType="application/json", schema=@Schema(implementation=HealthResponse.class))})})
    @ProvidesIntoMap
    @KeyClassMapKey(value=VertxRouteMapKeys.CassandraJmxHealthRouteKey.class)
    VertxRoute cassandraJmxHealthRoute(RouteBuilder.Factory factory, CassandraHealthHandler cassandraHealthHandler) {
        return factory.builderForUnauthorizedRoute().handler(cassandraHealthHandler).build();
    }

    @GET
    @Path(value="/api/v1/cassandra/gossip/__health")
    @Operation(summary="Check Cassandra gossip health", description="Returns the health status of Cassandra's gossip protocol")
    @APIResponses(value={@APIResponse(description="Cassandra gossip is healthy", responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=HealthResponse.class))}), @APIResponse(responseCode="503", description="Cassandra gossip is unhealthy", content={@Content(mediaType="application/json", schema=@Schema(implementation=HealthResponse.class))})})
    @ProvidesIntoMap
    @KeyClassMapKey(value=VertxRouteMapKeys.CassandraGossipHealthRouteKey.class)
    VertxRoute cassandraGossipHealthRoute(RouteBuilder.Factory factory, GossipHealthHandler gossipHealthHandler) {
        return factory.builderForUnauthorizedRoute().handler(gossipHealthHandler).build();
    }
}

