/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.metrics;

import com.codahale.metrics.Metric;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.cassandra.sidecar.common.DataObjectBuilder;

public class NamedMetric<T extends Metric> {
    public final String canonicalName;
    public final T metric;

    private NamedMetric(Builder<T> builder) {
        this.canonicalName = builder.makeFullName();
        this.metric = builder.register(this.canonicalName);
    }

    public static <T extends Metric> Builder<T> builder(Function<String, T> metricCreator) {
        return new Builder<T>(metricCreator);
    }

    public static class Tag {
        public final String key;
        public final String value;

        public static Tag of(String key, String value) {
            return new Tag(key, value);
        }

        private Tag(String key, String value) {
            this.key = Objects.requireNonNull(key, "Key can not be null");
            this.value = Objects.requireNonNull(value, "Value can not be null");
        }
    }

    public static class Builder<T extends Metric>
    implements DataObjectBuilder<Builder<T>, NamedMetric<T>> {
        private final Function<String, T> metricCreator;
        private final List<Tag> tags = new ArrayList<Tag>();
        private String domain;
        private String simpleName;

        public Builder(Function<String, T> metricCreator) {
            this.metricCreator = metricCreator;
        }

        public Builder<T> withDomain(String domain) {
            return (Builder)this.update(b -> {
                b.domain = domain;
            });
        }

        public Builder<T> withName(String simpleName) {
            return (Builder)this.update(b -> {
                b.simpleName = simpleName;
            });
        }

        public Builder<T> addTag(Tag tag) {
            return (Builder)this.update(b -> b.tags.add(tag));
        }

        public Builder<T> addTag(String key, String value) {
            return this.addTag(Tag.of(key, value));
        }

        public Builder<T> self() {
            return this;
        }

        public NamedMetric<T> build() {
            Objects.requireNonNull(this.metricCreator);
            Objects.requireNonNull(this.domain);
            Objects.requireNonNull(this.simpleName);
            return new NamedMetric(this);
        }

        private String makeFullName() {
            String domainPart = this.domain + ".";
            String combinedTags = !this.tags.isEmpty() ? this.combineTags() + "." : "";
            return domainPart + combinedTags + this.simpleName;
        }

        private String combineTags() {
            return this.tags.stream().map(tag -> tag.key + "=" + tag.value).collect(Collectors.joining("."));
        }

        private T register(String metricName) {
            return (T)((Metric)this.metricCreator.apply(metricName));
        }
    }
}

