/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.NoopMetricRegistry;
import com.codahale.metrics.Timer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;

public class FilteringMetricRegistry
extends MetricRegistry {
    private static final NoopMetricRegistry NO_OP_METRIC_REGISTRY = new NoopMetricRegistry();
    private final Predicate<String> isAllowed;
    private final Map<String, Metric> excludedMetrics = new ConcurrentHashMap<String, Metric>();

    public FilteringMetricRegistry(Predicate<String> isAllowedPredicate) {
        this.isAllowed = new CachedPredicate(isAllowedPredicate);
    }

    public Counter counter(String name) {
        if (this.isAllowed.test(name)) {
            return super.counter(name);
        }
        return this.typeChecked(this.excludedMetrics.computeIfAbsent(name, arg_0 -> ((NoopMetricRegistry)NO_OP_METRIC_REGISTRY).counter(arg_0)), Counter.class);
    }

    public Counter counter(String name, MetricRegistry.MetricSupplier<Counter> supplier) {
        if (this.isAllowed.test(name)) {
            return super.counter(name, supplier);
        }
        return this.typeChecked(this.excludedMetrics.computeIfAbsent(name, arg_0 -> ((NoopMetricRegistry)NO_OP_METRIC_REGISTRY).counter(arg_0)), Counter.class);
    }

    public Histogram histogram(String name) {
        if (this.isAllowed.test(name)) {
            return super.histogram(name);
        }
        return this.typeChecked(this.excludedMetrics.computeIfAbsent(name, arg_0 -> ((NoopMetricRegistry)NO_OP_METRIC_REGISTRY).histogram(arg_0)), Histogram.class);
    }

    public Histogram histogram(String name, MetricRegistry.MetricSupplier<Histogram> supplier) {
        if (this.isAllowed.test(name)) {
            return super.histogram(name, supplier);
        }
        return this.typeChecked(this.excludedMetrics.computeIfAbsent(name, arg_0 -> ((NoopMetricRegistry)NO_OP_METRIC_REGISTRY).histogram(arg_0)), Histogram.class);
    }

    public Meter meter(String name) {
        if (this.isAllowed.test(name)) {
            return super.meter(name);
        }
        return this.typeChecked(this.excludedMetrics.computeIfAbsent(name, arg_0 -> ((NoopMetricRegistry)NO_OP_METRIC_REGISTRY).meter(arg_0)), Meter.class);
    }

    public Meter meter(String name, MetricRegistry.MetricSupplier<Meter> supplier) {
        if (this.isAllowed.test(name)) {
            return super.meter(name, supplier);
        }
        return this.typeChecked(this.excludedMetrics.computeIfAbsent(name, arg_0 -> ((NoopMetricRegistry)NO_OP_METRIC_REGISTRY).meter(arg_0)), Meter.class);
    }

    public Timer timer(String name) {
        if (this.isAllowed.test(name)) {
            return super.timer(name);
        }
        return this.typeChecked(this.excludedMetrics.computeIfAbsent(name, arg_0 -> ((NoopMetricRegistry)NO_OP_METRIC_REGISTRY).timer(arg_0)), Timer.class);
    }

    public Timer timer(String name, MetricRegistry.MetricSupplier<Timer> supplier) {
        if (this.isAllowed.test(name)) {
            return super.timer(name, supplier);
        }
        return this.typeChecked(this.excludedMetrics.computeIfAbsent(name, arg_0 -> ((NoopMetricRegistry)NO_OP_METRIC_REGISTRY).timer(arg_0)), Timer.class);
    }

    public <T extends Gauge> T gauge(String name) {
        if (this.isAllowed.test(name)) {
            return (T)super.gauge(name);
        }
        return (T)this.typeChecked(this.excludedMetrics.computeIfAbsent(name, arg_0 -> ((NoopMetricRegistry)NO_OP_METRIC_REGISTRY).gauge(arg_0)), Gauge.class);
    }

    public <T extends Gauge> T gauge(String name, MetricRegistry.MetricSupplier<T> supplier) {
        if (this.isAllowed.test(name)) {
            return (T)super.gauge(name, supplier);
        }
        return (T)this.typeChecked(this.excludedMetrics.computeIfAbsent(name, k -> supplier.newMetric()), Gauge.class);
    }

    public Map<String, Metric> getMetrics() {
        HashMap<String, Metric> allMetrics = new HashMap<String, Metric>();
        allMetrics.putAll(super.getMetrics());
        allMetrics.putAll(this.excludedMetrics);
        return Collections.unmodifiableMap(allMetrics);
    }

    public Map<String, Metric> getIncludedMetrics() {
        return super.getMetrics();
    }

    public <T extends Metric> T register(String name, T metric) throws IllegalArgumentException {
        if (metric == null) {
            throw new IllegalArgumentException("Metric can not be null");
        }
        if (this.isAllowed.test(name)) {
            return (T)super.register(name, metric);
        }
        return (T)this.typeChecked(this.excludedMetrics.computeIfAbsent(name, key -> metric), metric.getClass());
    }

    private <T extends Metric> T typeChecked(Metric metric, Class<T> type) {
        if (type.isInstance(metric)) {
            return (T)metric;
        }
        throw new IllegalArgumentException("Metric already present with type " + metric.getClass());
    }

    static class CachedPredicate
    implements Predicate<String> {
        private final Predicate<String> delegate;
        private final Map<String, Boolean> results = new ConcurrentHashMap<String, Boolean>();

        CachedPredicate(Predicate<String> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean test(String s) {
            return this.results.computeIfAbsent(s, t -> this.delegate.test(s));
        }
    }
}

