/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.handlers.snapshots;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.web.RoutingContext;
import java.io.FileNotFoundException;
import java.nio.file.NoSuchFileException;
import java.util.Collections;
import java.util.Set;
import org.apache.cassandra.sidecar.acl.authorization.BasicPermissions;
import org.apache.cassandra.sidecar.common.server.StorageOperations;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.handlers.AbstractHandler;
import org.apache.cassandra.sidecar.handlers.AccessProtected;
import org.apache.cassandra.sidecar.handlers.data.SnapshotRequestParam;
import org.apache.cassandra.sidecar.utils.CassandraInputValidator;
import org.apache.cassandra.sidecar.utils.HttpExceptions;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.jetbrains.annotations.NotNull;

@Singleton
public class ClearSnapshotHandler
extends AbstractHandler<SnapshotRequestParam>
implements AccessProtected {
    @Inject
    public ClearSnapshotHandler(InstanceMetadataFetcher metadataFetcher, CassandraInputValidator validator, ExecutorPools executorPools) {
        super(metadataFetcher, executorPools, validator);
    }

    @Override
    public Set<Authorization> requiredAuthorizations() {
        return Collections.singleton(BasicPermissions.DELETE_SNAPSHOT.toAuthorization());
    }

    @Override
    public void handleInternal(RoutingContext context, HttpServerRequest httpRequest, @NotNull String host, SocketAddress remoteAddress, SnapshotRequestParam requestParams) {
        StorageOperations storageOperations = this.metadataFetcher.delegate(host).storageOperations();
        this.executorPools.service().runBlocking(() -> {
            this.logger.debug("Clearing snapshot request={}, remoteAddress={}, instance={}", new Object[]{requestParams, remoteAddress, host});
            storageOperations.clearSnapshot(requestParams.snapshotName(), requestParams.keyspace(), requestParams.tableName());
            context.response().end();
        }).onFailure(cause -> this.processFailure((Throwable)cause, context, host, remoteAddress, requestParams));
    }

    @Override
    protected void processFailure(Throwable cause, RoutingContext context, String host, SocketAddress remoteAddress, SnapshotRequestParam requestParams) {
        this.logger.error("ClearSnapshotHandler failed for request={}, remoteAddress={}, instance={}, method={}", new Object[]{requestParams, remoteAddress, host, context.request().method(), cause});
        if (cause instanceof FileNotFoundException || cause instanceof NoSuchFileException) {
            context.fail((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.NOT_FOUND, cause.getMessage()));
        } else {
            super.processFailure(cause, context, host, remoteAddress, requestParams);
        }
    }

    @Override
    protected SnapshotRequestParam extractParamsOrThrow(RoutingContext context) {
        SnapshotRequestParam snapshotRequestParam = SnapshotRequestParam.builder().qualifiedTableName(this.qualifiedTableName(context)).snapshotName(context.pathParam("snapshot")).build();
        this.validate(snapshotRequestParam);
        return snapshotRequestParam;
    }

    private void validate(SnapshotRequestParam request) {
        this.validator.validateSnapshotName(request.snapshotName());
    }
}

