/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.handlers.restore;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Future;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.Json;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.web.RoutingContext;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.sidecar.acl.authorization.BasicPermissions;
import org.apache.cassandra.sidecar.common.request.data.CreateRestoreJobRequestPayload;
import org.apache.cassandra.sidecar.common.response.data.CreateRestoreJobResponsePayload;
import org.apache.cassandra.sidecar.common.server.data.QualifiedTableName;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.db.RestoreJob;
import org.apache.cassandra.sidecar.db.RestoreJobDatabaseAccessor;
import org.apache.cassandra.sidecar.handlers.AbstractHandler;
import org.apache.cassandra.sidecar.handlers.AccessProtected;
import org.apache.cassandra.sidecar.routes.RoutingContextUtils;
import org.apache.cassandra.sidecar.utils.CassandraInputValidator;
import org.apache.cassandra.sidecar.utils.HttpExceptions;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.jetbrains.annotations.NotNull;

@Singleton
public class CreateRestoreJobHandler
extends AbstractHandler<CreateRestoreJobRequestPayload>
implements AccessProtected {
    private final RestoreJobDatabaseAccessor restoreJobDatabaseAccessor;

    @Inject
    public CreateRestoreJobHandler(ExecutorPools executorPools, InstanceMetadataFetcher instanceMetadataFetcher, RestoreJobDatabaseAccessor restoreJobDatabaseAccessor, CassandraInputValidator validator) {
        super(instanceMetadataFetcher, executorPools, validator);
        this.restoreJobDatabaseAccessor = restoreJobDatabaseAccessor;
    }

    @Override
    public Set<Authorization> requiredAuthorizations() {
        return Collections.singleton(BasicPermissions.CREATE_RESTORE_JOB.toAuthorization());
    }

    @Override
    protected void handleInternal(RoutingContext context, HttpServerRequest httpRequest, @NotNull String host, SocketAddress remoteAddress, CreateRestoreJobRequestPayload request) {
        this.validatePayload(request).compose(payload -> this.createRestoreJob(context, (CreateRestoreJobRequestPayload)payload)).onSuccess(createdJob -> {
            this.logger.info("Successfully persisted a new job. job={} request={} remoteAddress={} instance={}", new Object[]{createdJob, request, remoteAddress, host});
            context.response().setStatusCode(HttpResponseStatus.OK.code());
            context.json((Object)new CreateRestoreJobResponsePayload(createdJob.jobId, createdJob.status.name()));
        }).onFailure(cause -> this.processFailure((Throwable)cause, context, host, remoteAddress, request));
    }

    @Override
    protected CreateRestoreJobRequestPayload extractParamsOrThrow(RoutingContext context) {
        String bodyString = context.body().asString();
        if (bodyString == null || bodyString.equalsIgnoreCase("null")) {
            this.logger.warn("Bad request to create restore job. Received null payload.");
            throw HttpExceptions.wrapHttpException(HttpResponseStatus.BAD_REQUEST, "Unexpected null payload for request");
        }
        try {
            return (CreateRestoreJobRequestPayload)Json.decodeValue((String)bodyString, CreateRestoreJobRequestPayload.class);
        }
        catch (DecodeException decodeException) {
            this.logger.warn("Bad request to create restore job. Received invalid JSON payload.");
            throw HttpExceptions.wrapHttpException(HttpResponseStatus.BAD_REQUEST, "Invalid request payload", decodeException);
        }
    }

    private Future<CreateRestoreJobRequestPayload> validatePayload(CreateRestoreJobRequestPayload createRestoreJobRequestPayload) {
        UUID jobId = createRestoreJobRequestPayload.jobId();
        if (jobId == null) {
            return Future.succeededFuture((Object)createRestoreJobRequestPayload);
        }
        return this.executorPools.service().executeBlocking(() -> {
            if (this.restoreJobDatabaseAccessor.exists(jobId)) {
                this.logger.info("Restore job already exist. jobId={}", (Object)jobId);
                throw HttpExceptions.wrapHttpException(HttpResponseStatus.CONFLICT, String.format("Job id %s already exists", jobId));
            }
            return createRestoreJobRequestPayload;
        });
    }

    private Future<RestoreJob> createRestoreJob(RoutingContext context, CreateRestoreJobRequestPayload payload) {
        return RoutingContextUtils.getAsFuture(context, RoutingContextUtils.SC_QUALIFIED_TABLE_NAME).compose(tableName -> this.executorPools.service().executeBlocking(() -> this.restoreJobDatabaseAccessor.create(payload, (QualifiedTableName)tableName)));
    }
}

