/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.handlers.cdc;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.web.RoutingContext;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.cassandra.sidecar.acl.authorization.BasicPermissions;
import org.apache.cassandra.sidecar.common.request.Service;
import org.apache.cassandra.sidecar.db.ConfigAccessor;
import org.apache.cassandra.sidecar.db.ConfigAccessorFactory;
import org.apache.cassandra.sidecar.handlers.AccessProtected;
import org.apache.cassandra.sidecar.handlers.cdc.ServiceConfigValidator;
import org.apache.cassandra.sidecar.modules.ApiModule;
import org.apache.cassandra.sidecar.utils.HttpExceptions;

@Singleton
public class DeleteServiceConfigHandler
implements Handler<RoutingContext>,
AccessProtected {
    private final ConfigAccessorFactory configAccessorFactory;
    private final ServiceConfigValidator serviceConfigValidator;

    @Inject
    public DeleteServiceConfigHandler(ConfigAccessorFactory configAccessorFactory, ServiceConfigValidator serviceConfigValidator) {
        this.configAccessorFactory = configAccessorFactory;
        this.serviceConfigValidator = serviceConfigValidator;
    }

    public void handle(RoutingContext context) {
        String serviceName = context.pathParam("service");
        Service service = this.serviceConfigValidator.validateAndGet(serviceName);
        ConfigAccessor accessor = this.configAccessorFactory.configAccessor(service);
        try {
            accessor.deleteConfig();
        }
        catch (NoSuchElementException ex) {
            throw HttpExceptions.wrapHttpException(HttpResponseStatus.NOT_FOUND, "There is no configuration present for this service.");
        }
        context.json(ApiModule.OK_STATUS);
    }

    @Override
    public Set<Authorization> requiredAuthorizations() {
        return Collections.singleton(BasicPermissions.CDC.toAuthorization());
    }
}

