/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.db;

import com.datastax.driver.core.Row;
import java.math.BigInteger;
import java.util.Objects;
import java.util.UUID;
import org.apache.cassandra.sidecar.common.DataObjectBuilder;
import org.apache.cassandra.sidecar.common.request.data.CreateSliceRequestPayload;
import org.apache.cassandra.sidecar.common.server.cluster.locator.TokenRange;
import org.apache.cassandra.sidecar.common.server.data.QualifiedTableName;
import org.apache.cassandra.sidecar.db.RestoreJob;
import org.jetbrains.annotations.NotNull;

public class RestoreSlice {
    private final UUID jobId;
    private final String keyspace;
    private final String table;
    private final String sliceId;
    private final short bucketId;
    private final String bucket;
    private final String key;
    private final String checksum;
    private final BigInteger startToken;
    private final BigInteger endToken;
    private final long creationTimeNanos;
    private final long compressedSize;
    private final long uncompressedSize;

    public static Builder builder() {
        return new Builder();
    }

    private RestoreSlice(Builder builder) {
        this.jobId = builder.jobId;
        this.keyspace = builder.keyspace;
        this.table = builder.table;
        this.sliceId = builder.sliceId;
        this.bucketId = builder.bucketId;
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.checksum = builder.checksum;
        this.startToken = builder.startToken;
        this.endToken = builder.endToken;
        this.compressedSize = builder.compressedSize;
        this.uncompressedSize = builder.uncompressedSize;
        this.creationTimeNanos = System.nanoTime();
    }

    public Builder unbuild() {
        return new Builder(this);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.keyspace, this.table, this.sliceId, this.bucketId, this.bucket, this.key, this.checksum, this.startToken, this.endToken, this.compressedSize, this.uncompressedSize);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RestoreSlice)) {
            return false;
        }
        RestoreSlice that = (RestoreSlice)obj;
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.keyspace, that.keyspace) && Objects.equals(this.table, that.table) && Objects.equals(this.sliceId, that.sliceId) && Objects.equals(this.bucketId, that.bucketId) && Objects.equals(this.bucket, that.bucket) && Objects.equals(this.key, that.key) && Objects.equals(this.checksum, that.checksum) && Objects.equals(this.startToken, that.startToken) && Objects.equals(this.endToken, that.endToken) && this.compressedSize == that.compressedSize && this.uncompressedSize == that.uncompressedSize;
    }

    public RestoreSlice trimMaybe(@NotNull TokenRange localTokenRange) {
        TokenRange sliceRange = new TokenRange(this.startToken(), this.endToken());
        if (localTokenRange.encloses(sliceRange)) {
            return this;
        }
        if (localTokenRange.intersects(sliceRange)) {
            TokenRange intersection = localTokenRange.intersection(sliceRange);
            return this.unbuild().startToken(intersection.start().toBigInteger()).endToken(intersection.end().toBigInteger()).build();
        }
        throw new IllegalStateException("Token range of the slice does not intersect with the local token range. slice_range: " + sliceRange + ", local_range: " + localTokenRange);
    }

    public UUID jobId() {
        return this.jobId;
    }

    public String keyspace() {
        return this.keyspace;
    }

    public String table() {
        return this.table;
    }

    public String sliceId() {
        return this.sliceId;
    }

    public Short bucketId() {
        return this.bucketId;
    }

    public String bucket() {
        return this.bucket;
    }

    public String key() {
        return this.key;
    }

    public String checksum() {
        return this.checksum;
    }

    public BigInteger startToken() {
        return this.startToken;
    }

    public BigInteger endToken() {
        return this.endToken;
    }

    public long compressedSize() {
        return this.compressedSize;
    }

    public long uncompressedSize() {
        return this.uncompressedSize;
    }

    public long creationTimeNanos() {
        return this.creationTimeNanos;
    }

    public static RestoreSlice from(Row row, RestoreJob restoreJob) {
        Builder builder = new Builder();
        builder.jobId(row.getUUID("job_id"));
        builder.keyspace(restoreJob.keyspaceName);
        builder.table(restoreJob.tableName);
        builder.sliceId(row.getString("slice_id"));
        builder.bucketId(row.getShort("bucket_id"));
        builder.storageBucket(row.getString("bucket"));
        builder.storageKey(row.getString("key"));
        builder.checksum(row.getString("checksum"));
        builder.startToken(row.getVarint("start_token"));
        builder.endToken(row.getVarint("end_token"));
        builder.compressedSize(row.getLong("compressed_size"));
        builder.uncompressedSize(row.getLong("uncompressed_size"));
        return builder.build();
    }

    public static class Builder
    implements DataObjectBuilder<Builder, RestoreSlice> {
        private UUID jobId;
        private String keyspace;
        private String table;
        private String sliceId;
        private short bucketId;
        private String bucket;
        private String key;
        private String checksum;
        private BigInteger startToken;
        private BigInteger endToken;
        private long compressedSize;
        private long uncompressedSize;

        private Builder() {
        }

        private Builder(RestoreSlice slice) {
            this.jobId = slice.jobId;
            this.keyspace = slice.keyspace;
            this.table = slice.table;
            this.sliceId = slice.sliceId;
            this.bucketId = slice.bucketId;
            this.bucket = slice.bucket;
            this.key = slice.key;
            this.checksum = slice.checksum;
            this.startToken = slice.startToken;
            this.endToken = slice.endToken;
        }

        public Builder jobId(UUID jobId) {
            return (Builder)this.update(b -> {
                b.jobId = jobId;
            });
        }

        public Builder keyspace(String keyspace) {
            return (Builder)this.update(b -> {
                b.keyspace = keyspace;
            });
        }

        public Builder table(String table) {
            return (Builder)this.update(b -> {
                b.table = table;
            });
        }

        public Builder sliceId(String sliceId) {
            return (Builder)this.update(b -> {
                b.sliceId = sliceId;
            });
        }

        public Builder bucketId(short bucketId) {
            return (Builder)this.update(b -> {
                b.bucketId = bucketId;
            });
        }

        public Builder storageBucket(String storageBucket) {
            return (Builder)this.update(b -> {
                b.bucket = storageBucket;
            });
        }

        public Builder storageKey(String storageKey) {
            return (Builder)this.update(b -> {
                b.key = storageKey;
            });
        }

        public Builder checksum(String checksum) {
            return (Builder)this.update(b -> {
                b.checksum = checksum;
            });
        }

        public Builder startToken(BigInteger startToken) {
            return (Builder)this.update(b -> {
                b.startToken = startToken;
            });
        }

        public Builder endToken(BigInteger endToken) {
            return (Builder)this.update(b -> {
                b.endToken = endToken;
            });
        }

        public Builder compressedSize(long compressedSize) {
            return (Builder)this.update(b -> {
                b.compressedSize = compressedSize;
            });
        }

        public Builder uncompressedSize(long uncompressedSize) {
            return (Builder)this.update(b -> {
                b.uncompressedSize = uncompressedSize;
            });
        }

        public Builder qualifiedTableName(QualifiedTableName qualifiedTableName) {
            return (Builder)this.update(b -> {
                b.keyspace = qualifiedTableName.keyspace();
                b.table = qualifiedTableName.tableName();
            });
        }

        public Builder createSliceRequestPayload(CreateSliceRequestPayload payload) {
            return (Builder)this.update(b -> {
                b.sliceId = payload.sliceId();
                b.bucketId = payload.bucketIdAsShort();
                b.bucket = payload.bucket();
                b.key = payload.key();
                b.checksum = payload.checksum();
                b.startToken = payload.firstToken().subtract(BigInteger.ONE);
                b.endToken = payload.endToken();
                b.compressedSize = payload.compressedSizeOrZero();
                b.uncompressedSize = payload.uncompressedSizeOrZero();
            });
        }

        public RestoreSlice build() {
            return new RestoreSlice(this);
        }

        public Builder self() {
            return this;
        }
    }
}

