/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.datahub;

import com.datastax.driver.core.AbstractTableMetadata;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.UserType;
import com.google.common.collect.ImmutableMap;
import com.linkedin.common.urn.DataPlatformUrn;
import com.linkedin.data.template.SetMode;
import com.linkedin.schema.ArrayType;
import com.linkedin.schema.BooleanType;
import com.linkedin.schema.BytesType;
import com.linkedin.schema.DateType;
import com.linkedin.schema.MapType;
import com.linkedin.schema.NullType;
import com.linkedin.schema.NumberType;
import com.linkedin.schema.OtherSchema;
import com.linkedin.schema.SchemaField;
import com.linkedin.schema.SchemaFieldArray;
import com.linkedin.schema.SchemaFieldDataType;
import com.linkedin.schema.SchemaMetadata;
import com.linkedin.schema.StringType;
import com.linkedin.schema.TimeType;
import datahub.event.MetadataChangeProposalWrapper;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.cassandra.sidecar.datahub.IdentifiersProvider;
import org.apache.cassandra.sidecar.datahub.TableToAspectConverter;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableToSchemaMetadataConverter
extends TableToAspectConverter<SchemaMetadata> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableToSchemaMetadataConverter.class);
    protected static final long VERSION = 1L;
    protected static final SchemaFieldDataType.Type ARRAY = SchemaFieldDataType.Type.create((ArrayType)new ArrayType());
    protected static final SchemaFieldDataType.Type BOOLEAN = SchemaFieldDataType.Type.create((BooleanType)new BooleanType());
    protected static final SchemaFieldDataType.Type BYTES = SchemaFieldDataType.Type.create((BytesType)new BytesType());
    protected static final SchemaFieldDataType.Type DATE = SchemaFieldDataType.Type.create((DateType)new DateType());
    protected static final SchemaFieldDataType.Type MAP = SchemaFieldDataType.Type.create((MapType)new MapType());
    protected static final SchemaFieldDataType.Type NULL = SchemaFieldDataType.Type.create((NullType)new NullType());
    protected static final SchemaFieldDataType.Type NUMBER = SchemaFieldDataType.Type.create((NumberType)new NumberType());
    protected static final SchemaFieldDataType.Type STRING = SchemaFieldDataType.Type.create((StringType)new StringType());
    protected static final SchemaFieldDataType.Type TIME = SchemaFieldDataType.Type.create((TimeType)new TimeType());
    protected static final Map<DataType.Name, SchemaFieldDataType.Type> TYPES = new ImmutableMap.Builder().put((Object)DataType.Name.ASCII, (Object)STRING).put((Object)DataType.Name.BIGINT, (Object)NUMBER).put((Object)DataType.Name.BLOB, (Object)BYTES).put((Object)DataType.Name.BOOLEAN, (Object)BOOLEAN).put((Object)DataType.Name.COUNTER, (Object)NUMBER).put((Object)DataType.Name.DATE, (Object)DATE).put((Object)DataType.Name.DECIMAL, (Object)NUMBER).put((Object)DataType.Name.DOUBLE, (Object)NUMBER).put((Object)DataType.Name.FLOAT, (Object)NUMBER).put((Object)DataType.Name.INET, (Object)STRING).put((Object)DataType.Name.INT, (Object)NUMBER).put((Object)DataType.Name.LIST, (Object)ARRAY).put((Object)DataType.Name.MAP, (Object)MAP).put((Object)DataType.Name.SET, (Object)ARRAY).put((Object)DataType.Name.SMALLINT, (Object)NUMBER).put((Object)DataType.Name.TEXT, (Object)STRING).put((Object)DataType.Name.TIME, (Object)TIME).put((Object)DataType.Name.TIMESTAMP, (Object)DATE).put((Object)DataType.Name.TIMEUUID, (Object)STRING).put((Object)DataType.Name.TINYINT, (Object)NUMBER).put((Object)DataType.Name.TUPLE, (Object)ARRAY).put((Object)DataType.Name.UUID, (Object)STRING).put((Object)DataType.Name.VARCHAR, (Object)STRING).put((Object)DataType.Name.VARINT, (Object)NUMBER).build();

    public TableToSchemaMetadataConverter(@NotNull IdentifiersProvider identifiers) {
        super(identifiers);
    }

    @Override
    @NotNull
    public MetadataChangeProposalWrapper<SchemaMetadata> convert(@NotNull TableMetadata table) {
        String urn = this.identifiers.urnDataset(table);
        SchemaFieldArray fields = new SchemaFieldArray();
        table.getColumns().stream().flatMap(this::convertColumn).forEach(arg_0 -> ((SchemaFieldArray)fields).add(arg_0));
        String cql = table.exportAsString();
        SchemaMetadata.PlatformSchema schema = new SchemaMetadata.PlatformSchema();
        schema.setOtherSchema(new OtherSchema().setRawSchema(cql));
        String hash = DigestUtils.sha1Hex((String)cql);
        SchemaMetadata aspect = new SchemaMetadata().setSchemaName(table.getName()).setPlatform(new DataPlatformUrn(this.identifiers.urnDataPlatform())).setVersion(1L).setFields(fields).setPlatformSchema(schema).setHash(hash);
        return this.wrap(urn, aspect);
    }

    @NotNull
    protected Stream<SchemaField> convertColumn(@NotNull ColumnMetadata column) {
        DataType type = column.getType();
        AbstractTableMetadata table = column.getParent();
        boolean partition = table.getPartitionKey().contains(column);
        boolean key = partition || table.getClusteringColumns().contains(column);
        return this.convertType(column.getName(), type, partition, key);
    }

    @NotNull
    protected Stream<SchemaField> convertType(@NotNull String name, @NotNull DataType type, boolean partition, boolean key) {
        if (type instanceof UserType) {
            UserType udt = (UserType)type;
            return udt.getFieldNames().stream().flatMap(field -> this.convertType(name + "." + field, udt.getFieldType(field), partition, key));
        }
        DataType.Name cassandraType = type.getName();
        SchemaFieldDataType datahubType = this.convertType(cassandraType);
        String description = datahubType.getType().isNullType() ? "Unknown Cassandra data type " + cassandraType : null;
        return Stream.of(new SchemaField().setFieldPath(name).setNullable(!partition).setDescription(description, SetMode.REMOVE_IF_NULL).setType(datahubType).setNativeDataType(cassandraType.toString().toLowerCase()).setIsPartitioningKey(partition).setIsPartOfKey(key));
    }

    @NotNull
    protected SchemaFieldDataType convertType(@NotNull DataType.Name cassandraType) {
        SchemaFieldDataType.Type datahubType = TYPES.get(cassandraType);
        if (datahubType == null) {
            datahubType = NULL;
            LOGGER.error("Encountered an unknown data type " + cassandraType);
        }
        return new SchemaFieldDataType().setType(datahubType);
    }
}

