/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.config.yaml;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.sidecar.common.DataObjectBuilder;
import org.apache.cassandra.sidecar.common.server.utils.DurationSpec;
import org.apache.cassandra.sidecar.common.server.utils.SecondBoundConfiguration;
import org.apache.cassandra.sidecar.config.SchemaKeyspaceConfiguration;
import org.apache.cassandra.sidecar.exceptions.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaKeyspaceConfigurationImpl
implements SchemaKeyspaceConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaKeyspaceConfigurationImpl.class);
    public static final boolean DEFAULT_IS_ENABLED = false;
    public static final String DEFAULT_KEYSPACE = "sidecar_internal";
    public static final String DEFAULT_REPLICATION_STRATEGY = "SimpleStrategy";
    public static final int DEFAULT_REPLICATION_FACTOR = 1;
    public static final SecondBoundConfiguration DEFAULT_LEASE_SCHEMA_TTL = SecondBoundConfiguration.parse((String)"5m");
    public static final SecondBoundConfiguration MINIMUM_LEASE_SCHEMA_TTL = SecondBoundConfiguration.parse((String)"1m");
    @JsonProperty(value="is_enabled")
    protected final boolean isEnabled;
    @JsonProperty(value="keyspace")
    protected final String keyspace;
    @JsonProperty(value="replication_strategy")
    protected final String replicationStrategy;
    @JsonProperty(value="replication_factor")
    protected final int replicationFactor;
    protected SecondBoundConfiguration leaseSchemaTTL;

    protected SchemaKeyspaceConfigurationImpl() {
        this(SchemaKeyspaceConfigurationImpl.builder());
    }

    protected SchemaKeyspaceConfigurationImpl(Builder builder) {
        this.isEnabled = builder.isEnabled;
        this.keyspace = builder.keyspace;
        this.replicationStrategy = builder.replicationStrategy;
        this.replicationFactor = builder.replicationFactor;
        this.leaseSchemaTTL = builder.leaseSchemaTTL;
    }

    @Override
    @JsonProperty(value="is_enabled")
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    @JsonProperty(value="keyspace")
    public String keyspace() {
        return this.keyspace;
    }

    @Override
    @JsonProperty(value="replication_strategy")
    public String replicationStrategy() {
        return this.replicationStrategy;
    }

    @Override
    @JsonProperty(value="replication_factor")
    public int replicationFactor() {
        return this.replicationFactor;
    }

    @Override
    @JsonProperty(value="lease_schema_ttl")
    public SecondBoundConfiguration leaseSchemaTTL() {
        return this.leaseSchemaTTL;
    }

    @JsonProperty(value="lease_schema_ttl")
    public void setLeaseSchemaTTL(SecondBoundConfiguration leaseSchemaTTL) {
        if (leaseSchemaTTL.compareTo((DurationSpec)MINIMUM_LEASE_SCHEMA_TTL) < 0) {
            throw SchemaKeyspaceConfigurationImpl.leaseTTLConfigurationException(leaseSchemaTTL);
        }
        this.leaseSchemaTTL = leaseSchemaTTL;
    }

    @JsonProperty(value="lease_schema_ttl_sec")
    @Deprecated
    public void setLeaseSchemaTTLSeconds(long leaseSchemaTTLSeconds) {
        LOGGER.warn("'lease_schema_ttl_sec' is deprecated, use 'lease_schema_ttl' instead");
        this.setLeaseSchemaTTL(new SecondBoundConfiguration(leaseSchemaTTLSeconds, TimeUnit.SECONDS));
    }

    public static Builder builder() {
        return new Builder();
    }

    static ConfigurationException leaseTTLConfigurationException(SecondBoundConfiguration leaseSchemaTTL) {
        String message = String.format("Lease schema TTL value of %s is less than the minimum allowed value of %s", leaseSchemaTTL, MINIMUM_LEASE_SCHEMA_TTL);
        return new ConfigurationException(message);
    }

    public static class Builder
    implements DataObjectBuilder<Builder, SchemaKeyspaceConfigurationImpl> {
        private boolean isEnabled = false;
        private String keyspace = "sidecar_internal";
        private String replicationStrategy = "SimpleStrategy";
        private int replicationFactor = 1;
        private SecondBoundConfiguration leaseSchemaTTL = DEFAULT_LEASE_SCHEMA_TTL;

        protected Builder() {
        }

        public Builder self() {
            return this;
        }

        public Builder isEnabled(boolean isEnabled) {
            this.isEnabled = isEnabled;
            return this;
        }

        public Builder keyspace(String keyspace) {
            this.keyspace = keyspace;
            return this;
        }

        public Builder replicationStrategy(String replicationStrategy) {
            this.replicationStrategy = replicationStrategy;
            return this;
        }

        public Builder replicationFactor(int replicationFactor) {
            this.replicationFactor = replicationFactor;
            return this;
        }

        public Builder leaseSchemaTTL(SecondBoundConfiguration leaseSchemaTTL) {
            this.leaseSchemaTTL = leaseSchemaTTL;
            return this;
        }

        public SchemaKeyspaceConfigurationImpl build() {
            if (this.leaseSchemaTTL.compareTo((DurationSpec)MINIMUM_LEASE_SCHEMA_TTL) < 0) {
                throw SchemaKeyspaceConfigurationImpl.leaseTTLConfigurationException(this.leaseSchemaTTL);
            }
            return new SchemaKeyspaceConfigurationImpl(this);
        }
    }
}

