/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.config.yaml;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.cassandra.sidecar.common.DataObjectBuilder;
import org.apache.cassandra.sidecar.common.server.utils.MillisecondBoundConfiguration;
import org.apache.cassandra.sidecar.config.ClusterLeaseClaimConfiguration;
import org.apache.cassandra.sidecar.config.yaml.PeriodicTaskConfigurationImpl;

public class ClusterLeaseClaimConfigurationImpl
extends PeriodicTaskConfigurationImpl
implements ClusterLeaseClaimConfiguration {
    private static final String DEFAULT_ELECTORATE_MEMBERSHIP_STRATEGY = "MostReplicatedKeyspaceTokenZeroElectorateMembership";
    private static final MillisecondBoundConfiguration DEFAULT_INITIAL_DELAY_RANDOM_DELTA = MillisecondBoundConfiguration.parse((String)"30s");
    public static final PeriodicTaskConfigurationImpl.Builder DEFAULT_PERIODIC_TASK_BUILDER = PeriodicTaskConfigurationImpl.Builder.builder().enabled(true).initialDelay(MillisecondBoundConfiguration.parse((String)"1s")).executeInterval(MillisecondBoundConfiguration.parse((String)"100s"));
    @JsonProperty(value="electorate_membership_strategy")
    private final String electorateMembershipStrategy;
    @JsonProperty(value="initial_delay_random_delta")
    private final MillisecondBoundConfiguration initialDelayRandomDelta;

    @JsonCreator
    public ClusterLeaseClaimConfigurationImpl() {
        super(DEFAULT_PERIODIC_TASK_BUILDER);
        this.electorateMembershipStrategy = DEFAULT_ELECTORATE_MEMBERSHIP_STRATEGY;
        this.initialDelayRandomDelta = DEFAULT_INITIAL_DELAY_RANDOM_DELTA;
    }

    private ClusterLeaseClaimConfigurationImpl(Builder builder) {
        super(builder.periodicTaskBuilder);
        this.electorateMembershipStrategy = Objects.requireNonNull(builder.electorateMembershipStrategy, "electorateMembershipStrategy is required");
        this.initialDelayRandomDelta = builder.initialDelayRandomDelta;
    }

    @Override
    @JsonProperty(value="electorate_membership_strategy")
    public String electorateMembershipStrategy() {
        return this.electorateMembershipStrategy;
    }

    @Override
    @JsonProperty(value="initial_delay_random_delta")
    public MillisecondBoundConfiguration initialDelayRandomDelta() {
        return this.initialDelayRandomDelta;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements DataObjectBuilder<Builder, ClusterLeaseClaimConfigurationImpl> {
        private String electorateMembershipStrategy = "MostReplicatedKeyspaceTokenZeroElectorateMembership";
        private MillisecondBoundConfiguration initialDelayRandomDelta = DEFAULT_INITIAL_DELAY_RANDOM_DELTA;
        private final PeriodicTaskConfigurationImpl.Builder periodicTaskBuilder = DEFAULT_PERIODIC_TASK_BUILDER;

        private Builder() {
        }

        public Builder self() {
            return this;
        }

        public Builder electorateMembershipStrategy(String electorateMembershipStrategy) {
            return (Builder)this.update(b -> {
                b.electorateMembershipStrategy = electorateMembershipStrategy;
            });
        }

        public Builder initialDelayRandomDelta(MillisecondBoundConfiguration initialDelayRandomDelta) {
            return (Builder)this.update(b -> {
                b.initialDelayRandomDelta = initialDelayRandomDelta;
            });
        }

        public Builder overridePeriodicTaskConfiguration(Consumer<PeriodicTaskConfigurationImpl.Builder> overrides) {
            this.periodicTaskBuilder.update(overrides);
            return this.self();
        }

        public ClusterLeaseClaimConfigurationImpl build() {
            return new ClusterLeaseClaimConfigurationImpl(this);
        }
    }
}

