/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.config.yaml;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.sidecar.common.server.utils.MillisecondBoundConfiguration;
import org.apache.cassandra.sidecar.config.CacheConfiguration;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheConfigurationImpl
implements CacheConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheConfigurationImpl.class);
    protected MillisecondBoundConfiguration expireAfterAccess;
    @JsonProperty(value="maximum_size")
    protected final long maximumSize;
    @JsonProperty(value="enabled")
    protected final boolean enabled;
    @JsonProperty(value="warmup_retries")
    protected final int warmupRetries;
    protected MillisecondBoundConfiguration warmupRetryInterval;

    public CacheConfigurationImpl() {
        this(MillisecondBoundConfiguration.parse((String)"1h"), 100L, true, 5, MillisecondBoundConfiguration.parse((String)"1s"));
    }

    @VisibleForTesting
    public CacheConfigurationImpl(MillisecondBoundConfiguration expireAfterAccess, long maximumSize) {
        this(expireAfterAccess, maximumSize, true, 5, MillisecondBoundConfiguration.parse((String)"1s"));
    }

    public CacheConfigurationImpl(MillisecondBoundConfiguration expireAfterAccess, long maximumSize, boolean enabled, int warmupRetries, MillisecondBoundConfiguration warmupRetryInterval) {
        this.expireAfterAccess = expireAfterAccess;
        this.maximumSize = maximumSize;
        this.enabled = enabled;
        this.warmupRetries = warmupRetries;
        this.warmupRetryInterval = warmupRetryInterval;
    }

    @Override
    @JsonProperty(value="expire_after_access")
    public MillisecondBoundConfiguration expireAfterAccess() {
        return this.expireAfterAccess;
    }

    @JsonProperty(value="expire_after_access")
    public void setExpireAfterAccess(MillisecondBoundConfiguration expireAfterAccess) {
        this.expireAfterAccess = expireAfterAccess;
    }

    @JsonProperty(value="expire_after_access_millis")
    @Deprecated
    public void setExpireAfterAccessMillis(long expireAfterAccessMillis) {
        LOGGER.warn("'expire_after_access_millis' is deprecated, use 'expire_after_access' instead");
        this.setExpireAfterAccess(new MillisecondBoundConfiguration(expireAfterAccessMillis, TimeUnit.MILLISECONDS));
    }

    @Override
    @JsonProperty(value="maximum_size")
    public long maximumSize() {
        return this.maximumSize;
    }

    @Override
    @JsonProperty(value="enabled")
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    @JsonProperty(value="warmup_retries")
    public int warmupRetries() {
        return this.warmupRetries;
    }

    @Override
    @JsonProperty(value="warmup_retry_interval")
    public MillisecondBoundConfiguration warmupRetryInterval() {
        return this.warmupRetryInterval;
    }

    @JsonProperty(value="warmup_retry_interval")
    public void setWarmupRetryInterval(MillisecondBoundConfiguration warmupRetryInterval) {
        this.warmupRetryInterval = warmupRetryInterval;
    }

    @JsonProperty(value="warmup_retry_interval_millis")
    @Deprecated
    public void setWarmupRetryIntervalMillis(long warmupRetryIntervalMillis) {
        LOGGER.warn("'warmup_retry_interval_millis' is deprecated, use 'warmup_retry_interval' instead");
        this.setWarmupRetryInterval(new MillisecondBoundConfiguration(warmupRetryIntervalMillis, TimeUnit.MILLISECONDS));
    }
}

