/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.acl.authentication;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.oauth2.OAuth2Options;
import io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.impl.AuthenticationHandlerImpl;
import io.vertx.ext.web.handler.impl.OAuth2AuthHandlerImpl;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.sidecar.acl.authentication.JwtParameters;
import org.apache.cassandra.sidecar.acl.authentication.JwtRoleProcessor;
import org.apache.cassandra.sidecar.common.server.utils.DurationSpec;
import org.apache.cassandra.sidecar.common.utils.StringUtils;
import org.apache.cassandra.sidecar.tasks.PeriodicTask;
import org.apache.cassandra.sidecar.tasks.PeriodicTaskExecutor;
import org.apache.cassandra.sidecar.utils.HttpExceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReloadingJwtAuthenticationHandler
extends AuthenticationHandlerImpl<NoOpAuthenticationProvider> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReloadingJwtAuthenticationHandler.class);
    private final AtomicReference<OAuth2AuthHandlerImpl> delegateHandler = new AtomicReference();
    private final Vertx vertx;
    private final JwtParameters jwtParameters;
    private final JwtRoleProcessor roleProcessor;

    public ReloadingJwtAuthenticationHandler(Vertx vertx, JwtParameters jwtParameters, JwtRoleProcessor roleProcessor, PeriodicTaskExecutor periodicTaskExecutor) {
        super((AuthenticationProvider)NoOpAuthenticationProvider.INSTANCE);
        this.vertx = vertx;
        this.jwtParameters = jwtParameters;
        this.roleProcessor = roleProcessor;
        periodicTaskExecutor.schedule(new OAuth2AuthHandlerGenerateTask());
    }

    public void authenticate(RoutingContext context, Handler<AsyncResult<User>> handler) {
        OAuth2AuthHandlerImpl oAuth2AuthHandler = this.delegateHandler.get();
        if (oAuth2AuthHandler == null) {
            handler.handle((Object)Future.failedFuture((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.SERVICE_UNAVAILABLE, "JWT authentication handler unavailable")));
            return;
        }
        oAuth2AuthHandler.authenticate(context, authN -> {
            JsonObject decodedToken;
            if (authN.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.UNAUTHORIZED, authN.cause())));
                return;
            }
            User user = (User)authN.result();
            JsonObject jsonObject = decodedToken = user.attributes().containsKey("accessToken") ? user.attributes().getJsonObject("accessToken") : user.attributes().getJsonObject("idToken");
            if (decodedToken == null) {
                handler.handle((Object)Future.failedFuture((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.UNAUTHORIZED, "Could not process decoded JWT token")));
                return;
            }
            List<String> roles = this.extractCassandraRoles(decodedToken);
            String roleIntended = context.request().getHeader("cassandra-auth-role");
            if (StringUtils.isNotEmpty((String)roleIntended) && !roles.contains(roleIntended)) {
                String errMsg = String.format("User not authorized for role %s", roleIntended);
                handler.handle((Object)Future.failedFuture((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.UNAUTHORIZED, errMsg)));
                return;
            }
            List<String> rolesToAdd = StringUtils.isNotEmpty((String)roleIntended) ? List.of(roleIntended) : roles;
            user.attributes().put("cassandra_roles", rolesToAdd);
            handler.handle((Object)Future.succeededFuture((Object)user));
        });
    }

    private List<String> extractCassandraRoles(JsonObject decodedToken) {
        try {
            return this.roleProcessor.processRoles(decodedToken);
        }
        catch (Exception e) {
            LOGGER.debug("Error processing cassandra role from JWT token", (Throwable)e);
            return List.of();
        }
    }

    private class OAuth2AuthHandlerGenerateTask
    implements PeriodicTask {
        private final String taskName;

        private OAuth2AuthHandlerGenerateTask() {
            this.taskName = String.format("OAuth2AuthHandlerGenerateTask_%s_%s", ReloadingJwtAuthenticationHandler.this.jwtParameters.site(), ReloadingJwtAuthenticationHandler.this.jwtParameters.clientId());
        }

        @Override
        public DurationSpec delay() {
            return ReloadingJwtAuthenticationHandler.this.jwtParameters.configDiscoverInterval();
        }

        @Override
        public String name() {
            return this.taskName;
        }

        @Override
        public void execute(Promise<Void> promise) {
            if (!ReloadingJwtAuthenticationHandler.this.jwtParameters.enabled()) {
                ReloadingJwtAuthenticationHandler.this.delegateHandler.set(null);
                promise.complete();
                return;
            }
            OAuth2Options options = new OAuth2Options().setSite(ReloadingJwtAuthenticationHandler.this.jwtParameters.site()).setClientId(ReloadingJwtAuthenticationHandler.this.jwtParameters.clientId());
            OpenIDConnectAuth.discover((Vertx)ReloadingJwtAuthenticationHandler.this.vertx, (OAuth2Options)options).onSuccess(oAuthProvider -> {
                OAuth2AuthHandlerImpl handler = new OAuth2AuthHandlerImpl(ReloadingJwtAuthenticationHandler.this.vertx, oAuthProvider, null);
                if (!ReloadingJwtAuthenticationHandler.this.jwtParameters.scopes().isEmpty()) {
                    handler.withScopes(ReloadingJwtAuthenticationHandler.this.jwtParameters.scopes());
                }
                ReloadingJwtAuthenticationHandler.this.delegateHandler.set(handler);
                promise.complete();
            }).onFailure(cause -> {
                LOGGER.error("Error encountered during OpenID discovery", cause);
                promise.fail(cause);
            });
        }
    }

    protected static class NoOpAuthenticationProvider
    implements AuthenticationProvider {
        public static final NoOpAuthenticationProvider INSTANCE = new NoOpAuthenticationProvider();

        private NoOpAuthenticationProvider() {
        }

        public void authenticate(JsonObject credentials, Handler<AsyncResult<User>> resultHandler) {
            resultHandler.handle((Object)Future.succeededFuture());
        }
    }
}

