/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.common.request;

import io.netty.handler.codec.http.HttpMethod;
import java.util.UUID;
import org.apache.cassandra.sidecar.common.request.Request;
import org.apache.cassandra.sidecar.common.request.data.UpdateRestoreJobRequestPayload;

public class UpdateRestoreJobRequest
extends Request {
    private final UpdateRestoreJobRequestPayload requestPayload;

    public UpdateRestoreJobRequest(String keyspace, String table, UUID jobId, UpdateRestoreJobRequestPayload requestPayload) {
        super(UpdateRestoreJobRequest.requestURI(keyspace, table, jobId));
        this.requestPayload = requestPayload;
    }

    @Override
    public HttpMethod method() {
        return HttpMethod.PATCH;
    }

    @Override
    public Object requestBody() {
        return this.requestPayload;
    }

    static String requestURI(String keyspace, String table, UUID jobId) {
        return "/api/v1/keyspaces/:keyspace/tables/:table/restore-jobs/:jobId".replaceAll(":keyspace", keyspace).replaceAll(":table", table).replaceAll(":jobId", jobId.toString());
    }
}

