/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos.cleanup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.NoPayload;
import org.apache.cassandra.net.RequestCallbackWithFailure;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.repair.SharedContext;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.service.paxos.Ballot;
import org.apache.cassandra.service.paxos.cleanup.PaxosCleanupException;
import org.apache.cassandra.utils.concurrent.AsyncFuture;

public class PaxosCleanupComplete
extends AsyncFuture<Void>
implements RequestCallbackWithFailure<Void>,
Runnable {
    private final Set<InetAddressAndPort> waitingResponse;
    final TableId tableId;
    final Collection<Range<Token>> ranges;
    final Ballot lowBound;
    final boolean skippedReplicas;
    private final SharedContext ctx;
    public static final IVersionedSerializer<Request> serializer = new IVersionedSerializer<Request>(){

        @Override
        public void serialize(Request request, DataOutputPlus out, int version) throws IOException {
            request.tableId.serialize(out);
            request.lowBound.serialize(out);
            out.writeInt(request.ranges.size());
            for (Range<Token> rt : request.ranges) {
                AbstractBounds.tokenSerializer.serialize(rt, out, version);
            }
        }

        @Override
        public Request deserialize(DataInputPlus in, int version) throws IOException {
            TableId tableId = TableId.deserialize(in);
            Ballot lowBound = Ballot.deserialize(in);
            int numRanges = in.readInt();
            ArrayList<Range<Token>> ranges = new ArrayList<Range<Token>>();
            for (int i = 0; i < numRanges; ++i) {
                Range range = (Range)AbstractBounds.tokenSerializer.deserialize(in, DatabaseDescriptor.getPartitioner(), version);
                ranges.add(range);
            }
            return new Request(tableId, lowBound, ranges);
        }

        @Override
        public long serializedSize(Request request, int version) {
            long size = request.tableId.serializedSize();
            size += Ballot.sizeInBytes();
            size += (long)TypeSizes.sizeof(request.ranges.size());
            for (Range<Token> range : request.ranges) {
                size += AbstractBounds.tokenSerializer.serializedSize(range, version);
            }
            return size;
        }
    };
    public static final IVerbHandler<Request> verbHandler = PaxosCleanupComplete.createVerbHandler(SharedContext.Global.instance);

    PaxosCleanupComplete(SharedContext ctx, Collection<InetAddressAndPort> endpoints, TableId tableId, Collection<Range<Token>> ranges, Ballot lowBound, boolean skippedReplicas) {
        this.ctx = ctx;
        this.waitingResponse = new HashSet<InetAddressAndPort>(endpoints);
        this.tableId = tableId;
        this.ranges = ranges;
        this.lowBound = lowBound;
        this.skippedReplicas = skippedReplicas;
    }

    @Override
    public synchronized void run() {
        Request request = !this.skippedReplicas ? new Request(this.tableId, this.lowBound, this.ranges) : new Request(this.tableId, Ballot.none(), Collections.emptyList());
        Message<Request> message = Message.out(Verb.PAXOS2_CLEANUP_COMPLETE_REQ, request);
        for (InetAddressAndPort endpoint : this.waitingResponse) {
            this.ctx.messaging().sendWithCallback(message, endpoint, this);
        }
    }

    @Override
    public void onFailure(InetAddressAndPort from, RequestFailureReason reason) {
        this.tryFailure(new PaxosCleanupException("Timed out waiting on response from " + from));
    }

    @Override
    public synchronized void onResponse(Message<Void> msg) {
        if (this.isDone()) {
            return;
        }
        if (!this.waitingResponse.remove(msg.from())) {
            throw new IllegalArgumentException("Received unexpected response from " + msg.from());
        }
        if (this.waitingResponse.isEmpty()) {
            this.trySuccess(null);
        }
    }

    public static IVerbHandler<Request> createVerbHandler(SharedContext ctx) {
        return in -> {
            ColumnFamilyStore cfs = Schema.instance.getColumnFamilyStoreInstance(((Request)in.payload).tableId);
            cfs.onPaxosRepairComplete(((Request)in.payload).ranges, ((Request)in.payload).lowBound);
            ctx.messaging().respond(NoPayload.noPayload, in);
        };
    }

    public static class Request {
        final TableId tableId;
        final Ballot lowBound;
        final Collection<Range<Token>> ranges;

        Request(TableId tableId, Ballot lowBound, Collection<Range<Token>> ranges) {
            this.tableId = tableId;
            this.ranges = ranges;
            this.lowBound = lowBound;
        }
    }
}

