/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Timer;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.MetricNameFactory;

public class CIDRAuthorizerMetrics {
    private static final MetricNameFactory factory = new DefaultNameFactory("CIDRAuthorizer");
    public static final String CIDR_ACCESSES_REJECTED_COUNT_PREFIX = "CIDRAccessesRejectedCount - ";
    public static final String CIDR_ACCESSES_ACCEPTED_COUNT_PREFIX = "CIDRAccessesAcceptedCount - ";
    public static final String CIDR_CHECKS_LATENCY = "CIDRChecksLatency";
    public static final String CIDR_GROUPS_CACHE_RELOAD_COUNT = "CIDRGroupsMappingCacheReloadCount";
    public static final String CIDR_GROUPS_CACHE_RELOAD_LATENCY = "CIDRGroupsMappingCacheReloadLatency";
    public static final String LOOKUP_CIDR_GROUPS_FOR_IP_LATENCY = "LookupCIDRGroupsForIPLatency";
    public final Timer cidrChecksLatency;
    public final Counter cacheReloadCount;
    public final Timer cacheReloadLatency;
    public final Timer lookupCidrGroupsForIpLatency;
    public final ConcurrentHashMap<String, Counter> rejectedCidrAccessCount = new ConcurrentHashMap();
    public final ConcurrentHashMap<String, Counter> acceptedCidrAccessCount = new ConcurrentHashMap();

    public CIDRAuthorizerMetrics() {
        this.cidrChecksLatency = CassandraMetricsRegistry.Metrics.timer(factory.createMetricName(CIDR_CHECKS_LATENCY));
        this.cacheReloadCount = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName(CIDR_GROUPS_CACHE_RELOAD_COUNT));
        this.cacheReloadLatency = CassandraMetricsRegistry.Metrics.timer(factory.createMetricName(CIDR_GROUPS_CACHE_RELOAD_LATENCY));
        this.lookupCidrGroupsForIpLatency = CassandraMetricsRegistry.Metrics.timer(factory.createMetricName(LOOKUP_CIDR_GROUPS_FOR_IP_LATENCY));
    }

    private void incCounter(ConcurrentHashMap<String, Counter> metric, String metricPrefix, String cidrGroup) {
        metric.computeIfAbsent(cidrGroup, k -> CassandraMetricsRegistry.Metrics.counter(factory.createMetricName(metricPrefix + cidrGroup))).inc();
    }

    public void incrRejectedAccessCount(Set<String> cidrGroups) {
        if (cidrGroups == null || cidrGroups.isEmpty()) {
            this.incCounter(this.rejectedCidrAccessCount, CIDR_ACCESSES_REJECTED_COUNT_PREFIX, "Undefined");
            return;
        }
        for (String cidrGroup : cidrGroups) {
            this.incCounter(this.rejectedCidrAccessCount, CIDR_ACCESSES_REJECTED_COUNT_PREFIX, cidrGroup);
        }
    }

    public void incrAcceptedAccessCount(Set<String> cidrGroups) {
        if (cidrGroups == null || cidrGroups.isEmpty()) {
            this.incCounter(this.acceptedCidrAccessCount, CIDR_ACCESSES_ACCEPTED_COUNT_PREFIX, "Undefined");
            return;
        }
        for (String cidrGroup : cidrGroups) {
            this.incCounter(this.acceptedCidrAccessCount, CIDR_ACCESSES_ACCEPTED_COUNT_PREFIX, cidrGroup);
        }
    }
}

