/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.big;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.sstable.IndexInfo;
import org.apache.cassandra.io.sstable.format.SortedTablePartitionWriter;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.io.util.SequentialWriter;

public class BigFormatPartitionWriter
extends SortedTablePartitionWriter {
    @VisibleForTesting
    public static final int DEFAULT_GRANULARITY = 65536;
    private DataOutputBuffer buffer;
    private int indexSamplesSerializedSize;
    private final List<IndexInfo> indexSamples = new ArrayList<IndexInfo>();
    private DataOutputBuffer reusableBuffer;
    private int columnIndexCount;
    private int[] indexOffsets;
    private final ISerializer<IndexInfo> idxSerializer;
    private final int cacheSizeThreshold;
    private final int indexSize;

    BigFormatPartitionWriter(SerializationHeader header, SequentialWriter writer, Version version, ISerializer<IndexInfo> indexInfoSerializer) {
        this(header, writer, version, indexInfoSerializer, DatabaseDescriptor.getColumnIndexCacheSize(), DatabaseDescriptor.getColumnIndexSize(65536));
    }

    BigFormatPartitionWriter(SerializationHeader header, SequentialWriter writer, Version version, ISerializer<IndexInfo> indexInfoSerializer, int cacheSizeThreshold, int indexSize) {
        super(header, writer, version);
        this.idxSerializer = indexInfoSerializer;
        this.cacheSizeThreshold = cacheSizeThreshold;
        this.indexSize = indexSize;
    }

    @Override
    public void reset() {
        super.reset();
        this.columnIndexCount = 0;
        this.indexSamplesSerializedSize = 0;
        this.indexSamples.clear();
        if (this.buffer != null) {
            this.reusableBuffer = this.buffer;
        }
        this.buffer = null;
    }

    public int getColumnIndexCount() {
        return this.columnIndexCount;
    }

    public ByteBuffer buffer() {
        return this.buffer != null ? this.buffer.buffer() : null;
    }

    public List<IndexInfo> indexSamples() {
        if (this.indexSamplesSerializedSize + this.columnIndexCount * TypeSizes.sizeof(0) <= this.cacheSizeThreshold) {
            return this.indexSamples;
        }
        return null;
    }

    public int[] offsets() {
        return this.indexOffsets != null ? Arrays.copyOf(this.indexOffsets, this.columnIndexCount) : null;
    }

    private void addIndexBlock() throws IOException {
        IndexInfo cIndexInfo = new IndexInfo(this.firstClustering, this.lastClustering, this.startPosition, this.currentPosition() - this.startPosition, !this.openMarker.isLive() ? this.openMarker : null);
        if (this.indexOffsets == null) {
            this.indexOffsets = new int[10];
        } else {
            if (this.columnIndexCount >= this.indexOffsets.length) {
                this.indexOffsets = Arrays.copyOf(this.indexOffsets, this.indexOffsets.length + 10);
            }
            this.indexOffsets[this.columnIndexCount] = this.columnIndexCount == 0 ? 0 : (this.buffer != null ? Ints.checkedCast((long)this.buffer.position()) : this.indexSamplesSerializedSize);
        }
        ++this.columnIndexCount;
        if (this.buffer == null) {
            this.indexSamplesSerializedSize = (int)((long)this.indexSamplesSerializedSize + this.idxSerializer.serializedSize(cIndexInfo));
            if (this.indexSamplesSerializedSize + this.columnIndexCount * TypeSizes.sizeof(0) > this.cacheSizeThreshold) {
                this.buffer = this.reuseOrAllocateBuffer();
                for (IndexInfo indexSample : this.indexSamples) {
                    this.idxSerializer.serialize(indexSample, this.buffer);
                }
            } else {
                this.indexSamples.add(cIndexInfo);
            }
        }
        if (this.buffer != null) {
            this.idxSerializer.serialize(cIndexInfo, this.buffer);
        }
        this.firstClustering = null;
    }

    private DataOutputBuffer reuseOrAllocateBuffer() {
        if (this.reusableBuffer != null) {
            DataOutputBuffer buffer = this.reusableBuffer;
            buffer.clear();
            return buffer;
        }
        return new DataOutputBuffer(this.cacheSizeThreshold * 2);
    }

    @Override
    public void addUnfiltered(Unfiltered unfiltered) throws IOException {
        super.addUnfiltered(unfiltered);
        if (this.currentPosition() - this.startPosition >= (long)this.indexSize) {
            this.addIndexBlock();
        }
    }

    @Override
    public long finish() throws IOException {
        long endPosition = super.finish();
        if (this.written == 0) {
            return endPosition;
        }
        if (this.firstClustering != null) {
            this.addIndexBlock();
        }
        if (this.buffer != null) {
            for (int i = 0; i < this.columnIndexCount; ++i) {
                this.buffer.writeInt(this.indexOffsets[i]);
            }
        }
        assert (this.columnIndexCount > 0 && this.getHeaderLength() >= 0L);
        return endPosition;
    }

    public int indexInfoSerializedSize() {
        return this.buffer != null ? this.buffer.buffer().limit() : this.indexSamplesSerializedSize + this.columnIndexCount * TypeSizes.sizeof(0);
    }

    @Override
    public void close() {
    }
}

