/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.filter;

import java.util.Arrays;
import java.util.List;
import org.apache.cassandra.io.sstable.AbstractMetricsProviders;
import org.apache.cassandra.io.sstable.GaugeProvider;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableReaderWithFilter;

public class BloomFilterMetrics<R extends SSTableReaderWithFilter>
extends AbstractMetricsProviders<R> {
    public static final BloomFilterMetrics<?> instance = new BloomFilterMetrics();
    public final GaugeProvider<Long> bloomFilterFalsePositives = this.newGaugeProvider("BloomFilterFalsePositives", 0L, r -> r.getFilterTracker().getFalsePositiveCount(), Long::sum);
    public final GaugeProvider<Long> recentBloomFilterFalsePositives = this.newGaugeProvider("RecentBloomFilterFalsePositives", 0L, r -> r.getFilterTracker().getRecentFalsePositiveCount(), Long::sum);
    public final GaugeProvider<Long> bloomFilterDiskSpaceUsed = this.newGaugeProvider("BloomFilterDiskSpaceUsed", 0L, SSTableReaderWithFilter::getFilterSerializedSize, Long::sum);
    public final GaugeProvider<Long> bloomFilterOffHeapMemoryUsed = this.newGaugeProvider("BloomFilterOffHeapMemoryUsed", 0L, SSTableReaderWithFilter::getFilterOffHeapSize, Long::sum);
    public final GaugeProvider<Double> bloomFilterFalseRatio = this.newGaugeProvider("BloomFilterFalseRatio", readers -> {
        long falsePositiveCount = 0L;
        long truePositiveCount = 0L;
        long trueNegativeCount = 0L;
        for (SSTableReaderWithFilter sstable : readers) {
            falsePositiveCount += sstable.getFilterTracker().getFalsePositiveCount();
            truePositiveCount += sstable.getFilterTracker().getTruePositiveCount();
            trueNegativeCount += sstable.getFilterTracker().getTrueNegativeCount();
        }
        if (falsePositiveCount == 0L && truePositiveCount == 0L) {
            return 0.0;
        }
        return (double)falsePositiveCount / (double)(truePositiveCount + falsePositiveCount + trueNegativeCount);
    });
    public final GaugeProvider<Double> recentBloomFilterFalseRatio = this.newGaugeProvider("RecentBloomFilterFalseRatio", readers -> {
        long falsePositiveCount = 0L;
        long truePositiveCount = 0L;
        long trueNegativeCount = 0L;
        for (SSTableReaderWithFilter sstable : readers) {
            falsePositiveCount += sstable.getFilterTracker().getRecentFalsePositiveCount();
            truePositiveCount += sstable.getFilterTracker().getRecentTruePositiveCount();
            trueNegativeCount += sstable.getFilterTracker().getRecentTrueNegativeCount();
        }
        if (falsePositiveCount == 0L && truePositiveCount == 0L) {
            return 0.0;
        }
        return (double)falsePositiveCount / (double)(truePositiveCount + falsePositiveCount + trueNegativeCount);
    });
    private final List<GaugeProvider<?>> gaugeProviders = Arrays.asList(this.bloomFilterFalsePositives, this.recentBloomFilterFalsePositives, this.bloomFilterDiskSpaceUsed, this.bloomFilterOffHeapMemoryUsed, this.bloomFilterFalseRatio, this.recentBloomFilterFalseRatio);

    @Override
    protected R map(SSTableReader r) {
        if (r instanceof SSTableReaderWithFilter) {
            return (R)((SSTableReaderWithFilter)r);
        }
        return null;
    }

    public List<GaugeProvider<?>> getGaugeProviders() {
        return this.gaugeProviders;
    }
}

