/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk;

import com.carrotsearch.hppc.LongArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.tries.InMemoryTrie;
import org.apache.cassandra.index.sai.memory.MemtableIndex;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.index.sai.utils.PrimaryKeys;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.utils.AbstractGuavaIterator;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;

@NotThreadSafe
public class RowMapping {
    private static final InMemoryTrie.UpsertTransformer<Long, Long> OVERWRITE_TRANSFORMER = (existing, update) -> update;
    public static final RowMapping DUMMY = new RowMapping(){

        @Override
        public Iterator<Pair<ByteComparable, LongArrayList>> merge(MemtableIndex index) {
            return Collections.emptyIterator();
        }

        @Override
        public void complete() {
        }

        @Override
        public boolean isComplete() {
            return true;
        }

        @Override
        public void add(PrimaryKey key, long sstableRowId) {
        }

        @Override
        public int get(PrimaryKey key) {
            return -1;
        }
    };
    private final InMemoryTrie<Long> rowMapping = new InMemoryTrie(BufferType.OFF_HEAP);
    private boolean complete = false;

    private RowMapping() {
    }

    public static RowMapping create(OperationType opType) {
        if (opType == OperationType.FLUSH) {
            return new RowMapping();
        }
        return DUMMY;
    }

    public Iterator<Pair<ByteComparable, LongArrayList>> merge(MemtableIndex index) {
        assert (this.complete) : "RowMapping is not built.";
        final Iterator<Pair<ByteComparable, PrimaryKeys>> iterator = index.iterator();
        return new AbstractGuavaIterator<Pair<ByteComparable, LongArrayList>>(){

            @Override
            protected Pair<ByteComparable, LongArrayList> computeNext() {
                while (iterator.hasNext()) {
                    Pair pair = (Pair)iterator.next();
                    LongArrayList postings = null;
                    Iterator<PrimaryKey> primaryKeys = ((PrimaryKeys)pair.right).iterator();
                    while (primaryKeys.hasNext()) {
                        Long sstableRowId = (Long)RowMapping.this.rowMapping.get(primaryKeys.next());
                        if (sstableRowId == null) continue;
                        postings = postings == null ? new LongArrayList() : postings;
                        postings.add(sstableRowId.longValue());
                    }
                    if (postings == null) continue;
                    return Pair.create((ByteComparable)pair.left, postings);
                }
                return (Pair)this.endOfData();
            }
        };
    }

    public void complete() {
        assert (!this.complete) : "RowMapping can only be built once.";
        this.complete = true;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void add(PrimaryKey key, long sstableRowId) throws InMemoryTrie.SpaceExhaustedException {
        assert (!this.complete) : "Cannot modify and already built RowMapping.";
        this.rowMapping.putSingleton(key, sstableRowId, OVERWRITE_TRANSFORMER);
    }

    public int get(PrimaryKey key) {
        Long sstableRowId = (Long)this.rowMapping.get(key);
        return sstableRowId == null ? -1 : Math.toIntExact(sstableRowId);
    }
}

