/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Duration;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TemporalType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.UUIDSerializer;
import org.apache.cassandra.utils.TimeUUID;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSource;
import org.apache.cassandra.utils.bytecomparable.ByteSourceInverse;

public abstract class AbstractTimeUUIDType<T>
extends TemporalType<T> {
    AbstractTimeUUIDType() {
        super(AbstractType.ComparisonType.CUSTOM);
    }

    @Override
    public boolean allowsEmpty() {
        return true;
    }

    @Override
    public boolean isEmptyValueMeaningless() {
        return true;
    }

    @Override
    public <VL, VR> int compareCustom(VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR) {
        boolean p2;
        boolean p1 = accessorL.size(left) == 16;
        boolean bl = p2 = accessorR.size(right) == 16;
        if (!(p1 & p2)) {
            assert (p1 || accessorL.isEmpty(left));
            assert (p2 || accessorR.isEmpty(right));
            return p1 ? 1 : (p2 ? -1 : 0);
        }
        long msb1 = accessorL.getLong(left, 0);
        long msb2 = accessorR.getLong(right, 0);
        this.verifyVersion(msb1);
        this.verifyVersion(msb2);
        msb1 = AbstractTimeUUIDType.reorderTimestampBytes(msb1);
        msb2 = AbstractTimeUUIDType.reorderTimestampBytes(msb2);
        int c = Long.compare(msb1, msb2);
        if (c != 0) {
            return c;
        }
        long lsb1 = AbstractTimeUUIDType.signedBytesToNativeLong(accessorL.getLong(left, 8));
        long lsb2 = AbstractTimeUUIDType.signedBytesToNativeLong(accessorR.getLong(right, 8));
        return Long.compare(lsb1, lsb2);
    }

    @Override
    public <V> ByteSource asComparableBytes(ValueAccessor<V> accessor, V data, ByteComparable.Version version) {
        if (accessor.isEmpty(data)) {
            return null;
        }
        long hiBits = accessor.getLong(data, 0);
        this.verifyVersion(hiBits);
        ByteBuffer swizzled = ByteBuffer.allocate(16);
        swizzled.putLong(0, TimeUUIDType.reorderTimestampBytes(hiBits));
        swizzled.putLong(8, accessor.getLong(data, 8) ^ 0x8080808080808080L);
        return ByteSource.fixedLength(swizzled);
    }

    @Override
    public <V> V fromComparableBytes(ValueAccessor<V> accessor, ByteSource.Peekable comparableBytes, ByteComparable.Version version) {
        if (comparableBytes == null) {
            return accessor.empty();
        }
        long hiBits = ByteSourceInverse.getUnsignedFixedLengthAsLong(comparableBytes, 8);
        long loBits = ByteSourceInverse.getUnsignedFixedLengthAsLong(comparableBytes, 8);
        hiBits = AbstractTimeUUIDType.reorderBackTimestampBytes(hiBits);
        this.verifyVersion(hiBits);
        return UUIDType.makeUuidBytes(accessor, hiBits, loBits ^= 0x8080808080808080L);
    }

    public static long signedBytesToNativeLong(long signedBytes) {
        return signedBytes ^ 0x80808080808080L;
    }

    private void verifyVersion(long hiBits) {
        long version = hiBits >>> 12 & 0xFL;
        if (version != 1L) {
            throw new MarshalException(String.format("Invalid UUID version %d for timeuuid", version));
        }
    }

    protected static long reorderTimestampBytes(long input) {
        return input << 48 | input << 16 & 0xFFFF00000000L | input >>> 32;
    }

    protected static long reorderBackTimestampBytes(long input) {
        return input << 32 | input >>> 16 & 0xFFFF0000L | input >>> 48;
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        ByteBuffer parsed = UUIDType.parse(source);
        if (parsed == null) {
            throw new MarshalException(String.format("Unknown timeuuid representation: %s", source));
        }
        if (parsed.remaining() == 16 && UUIDType.version(parsed) != 1) {
            throw new MarshalException("TimeUUID supports only version 1 UUIDs");
        }
        return parsed;
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        try {
            return new Constants.Value(this.fromString((String)parsed));
        }
        catch (ClassCastException exc) {
            throw new MarshalException(String.format("Expected a string representation of a timeuuid, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.TIMEUUID;
    }

    @Override
    public ByteBuffer decomposeUntyped(Object value) {
        if (value instanceof UUID) {
            return UUIDSerializer.instance.serialize((UUID)value);
        }
        if (value instanceof TimeUUID) {
            return TimeUUID.Serializer.instance.serialize((TimeUUID)value);
        }
        return super.decomposeUntyped(value);
    }

    @Override
    public int valueLengthIfFixed() {
        return 16;
    }

    @Override
    public long toTimeInMillis(ByteBuffer value) {
        return TimeUUID.deserialize(value).unix(TimeUnit.MILLISECONDS);
    }

    @Override
    public ByteBuffer addDuration(Number temporal, Duration duration) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer substractDuration(Number temporal, Duration duration) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer now() {
        return ByteBuffer.wrap(TimeUUID.Generator.nextTimeUUIDAsBytes());
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof AbstractTimeUUIDType;
    }
}

