/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.restrictions;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.cql3.Ordering;
import org.apache.cassandra.cql3.QualifiedName;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.WhereClause;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.restrictions.ClusteringColumnRestrictions;
import org.apache.cassandra.cql3.restrictions.CustomIndexExpression;
import org.apache.cassandra.cql3.restrictions.IndexRestrictions;
import org.apache.cassandra.cql3.restrictions.PartitionKeyRestrictions;
import org.apache.cassandra.cql3.restrictions.PartitionKeySingleRestrictionSet;
import org.apache.cassandra.cql3.restrictions.Restriction;
import org.apache.cassandra.cql3.restrictions.RestrictionSet;
import org.apache.cassandra.cql3.restrictions.Restrictions;
import org.apache.cassandra.cql3.restrictions.SingleRestriction;
import org.apache.cassandra.cql3.statements.Bound;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.cql3.statements.StatementType;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.guardrails.Guardrails;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.VectorType;
import org.apache.cassandra.db.virtual.VirtualKeyspaceRegistry;
import org.apache.cassandra.db.virtual.VirtualTable;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.ExcludingBounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.IncludingExcludingBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.index.IndexRegistry;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.utils.btree.BTreeSet;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public final class StatementRestrictions {
    private static final String ALLOW_FILTERING_MESSAGE = "Cannot execute this query as it might involve data filtering and thus may have unpredictable performance. ";
    public static final String REQUIRES_ALLOW_FILTERING_MESSAGE = "Cannot execute this query as it might involve data filtering and thus may have unpredictable performance. If you want to execute this query despite the performance unpredictability, use ALLOW FILTERING";
    public static final String CANNOT_USE_ALLOW_FILTERING_MESSAGE = "Cannot execute this query as it might involve data filtering and thus may have unpredictable performance. Executing this query despite the performance unpredictability with ALLOW FILTERING has been disabled by the allow_filtering_enabled property in cassandra.yaml";
    public static final String ANN_REQUIRES_INDEX_MESSAGE = "ANN ordering by vector requires the column to be indexed";
    public static final String VECTOR_INDEXES_ANN_ONLY_MESSAGE = "Vector indexes only support ANN queries";
    public static final String ANN_ONLY_SUPPORTED_ON_VECTOR_MESSAGE = "ANN ordering is only supported on float vector indexes";
    public static final String ANN_REQUIRES_INDEXED_FILTERING_MESSAGE = "ANN ordering by vector requires all restricted column(s) to be indexed";
    private final StatementType type;
    public final TableMetadata table;
    private PartitionKeyRestrictions partitionKeyRestrictions;
    private ClusteringColumnRestrictions clusteringColumnsRestrictions;
    private RestrictionSet nonPrimaryKeyRestrictions;
    private Set<ColumnMetadata> notNullColumns;
    private final IndexRestrictions filterRestrictions = new IndexRestrictions();
    private boolean usesSecondaryIndexing;
    private boolean isKeyRange;
    private boolean hasRegularColumnsRestrictions;

    public static StatementRestrictions empty(StatementType type, TableMetadata table) {
        return new StatementRestrictions(type, table, false);
    }

    private StatementRestrictions(StatementType type, TableMetadata table, boolean allowFiltering) {
        this.type = type;
        this.table = table;
        this.partitionKeyRestrictions = new PartitionKeySingleRestrictionSet(table.partitionKeyAsClusteringComparator());
        this.clusteringColumnsRestrictions = new ClusteringColumnRestrictions(table, allowFiltering);
        this.nonPrimaryKeyRestrictions = new RestrictionSet();
        this.notNullColumns = new HashSet<ColumnMetadata>();
    }

    public StatementRestrictions(ClientState state, StatementType type, TableMetadata table, WhereClause whereClause, VariableSpecifications boundNames, List<Ordering> orderings, boolean selectsOnlyStaticColumns, boolean allowFiltering, boolean forView) {
        this(state, type, table, whereClause, boundNames, orderings, selectsOnlyStaticColumns, type.allowUseOfSecondaryIndices(), allowFiltering, forView);
    }

    public StatementRestrictions(ClientState state, StatementType type, TableMetadata table, WhereClause whereClause, VariableSpecifications boundNames, List<Ordering> orderings, boolean selectsOnlyStaticColumns, boolean allowUseOfSecondaryIndices, boolean allowFiltering, boolean forView) {
        this(type, table, allowFiltering);
        IndexRegistry indexRegistry = type.allowUseOfSecondaryIndices() ? IndexRegistry.obtain(table) : null;
        for (Relation relation : whereClause.relations) {
            if ((relation.isContains() || relation.isContainsKey()) && (type.isUpdate() || type.isDelete())) {
                throw RequestValidations.invalidRequest("Cannot use %s with %s", new Object[]{type, relation.operator()});
            }
            if (relation.operator() == Operator.IS_NOT) {
                if (!forView) {
                    throw new InvalidRequestException("Unsupported restriction: " + relation);
                }
                this.notNullColumns.addAll(relation.toRestriction(table, boundNames).getColumnDefs());
                continue;
            }
            if (relation.isLIKE()) {
                Restriction restriction = relation.toRestriction(table, boundNames);
                if (!type.allowUseOfSecondaryIndices() || !restriction.hasSupportingIndex(indexRegistry)) {
                    throw new InvalidRequestException(String.format("LIKE restriction is only supported on properly indexed columns. %s is not valid.", relation));
                }
                this.addRestriction(restriction, indexRegistry);
                continue;
            }
            this.addRestriction(relation.toRestriction(table, boundNames), indexRegistry);
        }
        this.nonPrimaryKeyRestrictions = this.addOrderingRestrictions(orderings, this.nonPrimaryKeyRestrictions);
        this.hasRegularColumnsRestrictions = this.nonPrimaryKeyRestrictions.hasRestrictionFor(ColumnMetadata.Kind.REGULAR);
        boolean hasQueriableClusteringColumnIndex = false;
        boolean hasQueriableIndex = false;
        if (allowUseOfSecondaryIndices) {
            if (whereClause.containsCustomExpressions()) {
                this.processCustomIndexExpressions(whereClause.expressions, boundNames, indexRegistry);
            }
            hasQueriableClusteringColumnIndex = this.clusteringColumnsRestrictions.hasSupportingIndex(indexRegistry);
            hasQueriableIndex = !this.filterRestrictions.getCustomIndexExpressions().isEmpty() || hasQueriableClusteringColumnIndex || this.partitionKeyRestrictions.hasSupportingIndex(indexRegistry) || this.nonPrimaryKeyRestrictions.hasSupportingIndex(indexRegistry);
        }
        this.processPartitionKeyRestrictions(state, hasQueriableIndex, allowFiltering, forView);
        if (this.usesSecondaryIndexing || this.partitionKeyRestrictions.needFiltering(table)) {
            this.filterRestrictions.add(this.partitionKeyRestrictions);
        }
        if (selectsOnlyStaticColumns && this.hasClusteringColumnsRestrictions()) {
            if (type.isDelete() || type.isUpdate()) {
                throw RequestValidations.invalidRequest("Invalid restrictions on clustering columns since the %s statement modifies only static columns", new Object[]{type});
            }
            if (type.isSelect()) {
                throw RequestValidations.invalidRequest("Cannot restrict clustering columns when selecting only static columns");
            }
        }
        this.processClusteringColumnsRestrictions(hasQueriableIndex, selectsOnlyStaticColumns, forView, allowFiltering);
        if (this.isKeyRange && hasQueriableClusteringColumnIndex) {
            this.usesSecondaryIndexing = true;
        }
        if (this.usesSecondaryIndexing || this.clusteringColumnsRestrictions.needFiltering()) {
            this.filterRestrictions.add(this.clusteringColumnsRestrictions);
        }
        if (!this.nonPrimaryKeyRestrictions.isEmpty()) {
            if (!type.allowNonPrimaryKeyInWhereClause()) {
                Collection<ColumnIdentifier> nonPrimaryKeyColumns = ColumnMetadata.toIdentifiers(this.nonPrimaryKeyRestrictions.getColumnDefs());
                throw RequestValidations.invalidRequest("Non PRIMARY KEY columns found in where clause: %s ", Joiner.on((String)", ").join(nonPrimaryKeyColumns));
            }
            Optional<SingleRestriction> annRestriction = Streams.stream((Iterable)this.nonPrimaryKeyRestrictions).filter(SingleRestriction::isANN).findFirst();
            if (annRestriction.isPresent()) {
                List nonIndexedColumns;
                ColumnMetadata annColumn = annRestriction.get().getFirstColumn();
                if (!annColumn.type.isVector() || !(((VectorType)annColumn.type).elementType instanceof FloatType)) {
                    throw RequestValidations.invalidRequest(ANN_ONLY_SUPPORTED_ON_VECTOR_MESSAGE);
                }
                if (indexRegistry == null || indexRegistry.listIndexes().stream().noneMatch(i -> i.dependsOn(annColumn))) {
                    throw RequestValidations.invalidRequest(ANN_REQUIRES_INDEX_MESSAGE);
                }
                if (this.partitionKeyRestrictions.needFiltering(table)) {
                    throw RequestValidations.invalidRequest(ANN_REQUIRES_INDEXED_FILTERING_MESSAGE);
                }
                List nonAnnColumns = Streams.stream((Iterable)this.nonPrimaryKeyRestrictions).filter(r -> !r.isANN()).map(Restriction::getFirstColumn).collect(Collectors.toList());
                Collection<ColumnMetadata> clusteringColumns = this.clusteringColumnsRestrictions.getColumnDefinitions();
                if (!(nonAnnColumns.isEmpty() && clusteringColumns.isEmpty() || (nonIndexedColumns = Stream.concat(nonAnnColumns.stream(), clusteringColumns.stream()).filter(c -> indexRegistry.listIndexes().stream().noneMatch(i -> i.dependsOn((ColumnMetadata)c))).collect(Collectors.toList())).isEmpty() || clusteringColumns.containsAll(nonIndexedColumns) && !this.partitionKeyRestrictions.hasUnrestrictedPartitionKeyComponents(table) && !this.clusteringColumnsRestrictions.needFiltering())) {
                    throw RequestValidations.invalidRequest(ANN_REQUIRES_INDEXED_FILTERING_MESSAGE);
                }
            } else {
                Optional<ColumnMetadata> vectorColumn = this.nonPrimaryKeyRestrictions.getColumnDefs().stream().filter(c -> c.type.isVector()).findFirst();
                if (vectorColumn.isPresent() && indexRegistry.listIndexes().stream().anyMatch(i -> i.dependsOn((ColumnMetadata)vectorColumn.get()))) {
                    throw RequestValidations.invalidRequest(VECTOR_INDEXES_ANN_ONLY_MESSAGE);
                }
            }
            if (hasQueriableIndex) {
                this.usesSecondaryIndexing = true;
            } else if (!allowFiltering && this.requiresAllowFilteringIfNotSpecified()) {
                throw RequestValidations.invalidRequest(StatementRestrictions.allowFilteringMessage(state));
            }
            this.filterRestrictions.add(this.nonPrimaryKeyRestrictions);
        }
        if (this.usesSecondaryIndexing) {
            this.validateSecondaryIndexSelections();
        }
    }

    public boolean requiresAllowFilteringIfNotSpecified() {
        if (!this.table.isVirtual()) {
            return true;
        }
        VirtualTable tableNullable = VirtualKeyspaceRegistry.instance.getTableNullable(this.table.id);
        assert (tableNullable != null);
        return !tableNullable.allowFilteringImplicitly();
    }

    private void addRestriction(Restriction restriction, IndexRegistry indexRegistry) {
        ColumnMetadata def = restriction.getFirstColumn();
        if (def.isPartitionKey()) {
            this.partitionKeyRestrictions = this.partitionKeyRestrictions.mergeWith(restriction);
        } else if (def.isClusteringColumn()) {
            this.clusteringColumnsRestrictions = this.clusteringColumnsRestrictions.mergeWith(restriction, indexRegistry);
        } else {
            this.nonPrimaryKeyRestrictions = this.nonPrimaryKeyRestrictions.addRestriction((SingleRestriction)restriction);
        }
    }

    public void addFunctionsTo(List<Function> functions) {
        this.partitionKeyRestrictions.addFunctionsTo(functions);
        this.clusteringColumnsRestrictions.addFunctionsTo(functions);
        this.nonPrimaryKeyRestrictions.addFunctionsTo(functions);
    }

    public IndexRestrictions getIndexRestrictions() {
        return this.filterRestrictions;
    }

    public Set<ColumnMetadata> nonPKRestrictedColumns(boolean includeNotNullRestrictions) {
        HashSet<ColumnMetadata> columns = new HashSet<ColumnMetadata>();
        for (Restrictions r : this.filterRestrictions.getRestrictions()) {
            for (ColumnMetadata def : r.getColumnDefs()) {
                if (def.isPrimaryKeyColumn()) continue;
                columns.add(def);
            }
        }
        if (includeNotNullRestrictions) {
            for (ColumnMetadata def : this.notNullColumns) {
                if (def.isPrimaryKeyColumn()) continue;
                columns.add(def);
            }
        }
        return columns;
    }

    public Set<ColumnMetadata> notNullColumns() {
        return this.notNullColumns;
    }

    public boolean isRestricted(ColumnMetadata column) {
        if (this.notNullColumns.contains(column)) {
            return true;
        }
        return this.getRestrictions(column.kind).getColumnDefs().contains(column);
    }

    public boolean keyIsInRelation() {
        return this.partitionKeyRestrictions.hasIN();
    }

    public boolean isKeyRange() {
        return this.isKeyRange;
    }

    public boolean isColumnRestrictedByEq(ColumnMetadata columnDef) {
        Set<Restriction> restrictions = this.getRestrictions(columnDef.kind).getRestrictions(columnDef);
        return restrictions.stream().filter(SingleRestriction.class::isInstance).anyMatch(p -> ((SingleRestriction)p).isEQ());
    }

    public boolean isEqualityRestricted(ColumnMetadata column) {
        block7: {
            block8: {
                block6: {
                    if (column.kind != ColumnMetadata.Kind.PARTITION_KEY) break block6;
                    if (!this.partitionKeyRestrictions.hasOnlyEqualityRestrictions()) break block7;
                    for (ColumnMetadata restricted : this.partitionKeyRestrictions.getColumnDefinitions()) {
                        if (!restricted.name.equals(column.name)) continue;
                        return true;
                    }
                    break block7;
                }
                if (column.kind != ColumnMetadata.Kind.CLUSTERING) break block8;
                if (!this.hasClusteringColumnsRestrictions()) break block7;
                for (SingleRestriction restriction : this.clusteringColumnsRestrictions.getRestrictionSet()) {
                    if (!restriction.isEqualityBased()) continue;
                    if (restriction.isMultiColumn()) {
                        for (ColumnMetadata restricted : restriction.getColumnDefs()) {
                            if (!restricted.name.equals(column.name)) continue;
                            return true;
                        }
                        continue;
                    }
                    if (!restriction.getFirstColumn().name.equals(column.name)) continue;
                    return true;
                }
                break block7;
            }
            if (this.hasNonPrimaryKeyRestrictions()) {
                for (SingleRestriction restriction : this.nonPrimaryKeyRestrictions) {
                    if (!restriction.getFirstColumn().name.equals(column.name) || !restriction.isEqualityBased()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isTopK() {
        return this.nonPrimaryKeyRestrictions.hasAnn();
    }

    private Restrictions getRestrictions(ColumnMetadata.Kind kind) {
        switch (kind) {
            case PARTITION_KEY: {
                return this.partitionKeyRestrictions;
            }
            case CLUSTERING: {
                return this.clusteringColumnsRestrictions;
            }
        }
        return this.nonPrimaryKeyRestrictions;
    }

    public boolean usesSecondaryIndexing() {
        return this.usesSecondaryIndexing;
    }

    private RestrictionSet addOrderingRestrictions(List<Ordering> orderings, RestrictionSet restrictionSet) {
        List annOrderings = orderings.stream().filter(o -> o.expression.hasNonClusteredOrdering()).collect(Collectors.toList());
        if (annOrderings.size() > 1) {
            throw new InvalidRequestException("Cannot specify more than one ANN ordering");
        }
        if (annOrderings.size() == 1) {
            if (orderings.size() > 1) {
                throw new InvalidRequestException("ANN ordering does not support any other ordering");
            }
            Ordering annOrdering = (Ordering)annOrderings.get(0);
            if (annOrdering.direction != Ordering.Direction.ASC) {
                throw new InvalidRequestException("Descending ANN ordering is not supported");
            }
            SingleRestriction restriction = annOrdering.expression.toRestriction();
            return restrictionSet.addRestriction(restriction);
        }
        return restrictionSet;
    }

    private static Iterable<Restriction> allColumnRestrictions(ClusteringColumnRestrictions clusteringColumnsRestrictions, RestrictionSet nonPrimaryKeyRestrictions) {
        return Iterables.concat((Iterable)clusteringColumnsRestrictions.getRestrictionSet(), (Iterable)nonPrimaryKeyRestrictions);
    }

    private void processPartitionKeyRestrictions(ClientState state, boolean hasQueriableIndex, boolean allowFiltering, boolean forView) {
        if (!this.type.allowPartitionKeyRanges()) {
            RequestValidations.checkFalse(this.partitionKeyRestrictions.isOnToken(), "The token function cannot be used in WHERE clauses for %s statements", (Object)this.type);
            if (this.partitionKeyRestrictions.hasUnrestrictedPartitionKeyComponents(this.table)) {
                throw RequestValidations.invalidRequest("Some partition key parts are missing: %s", Joiner.on((String)", ").join(this.getPartitionKeyUnrestrictedComponents()));
            }
            RequestValidations.checkFalse(this.partitionKeyRestrictions.hasSlice(), "Only EQ and IN relation are supported on the partition key (unless you use the token() function) for %s statements", (Object)this.type);
        } else {
            if (this.partitionKeyRestrictions.isOnToken()) {
                this.isKeyRange = true;
            }
            if (this.partitionKeyRestrictions.isEmpty() && this.partitionKeyRestrictions.hasUnrestrictedPartitionKeyComponents(this.table)) {
                this.isKeyRange = true;
                this.usesSecondaryIndexing = hasQueriableIndex;
            }
            if (this.partitionKeyRestrictions.needFiltering(this.table)) {
                if (!allowFiltering && !forView && !hasQueriableIndex && this.requiresAllowFilteringIfNotSpecified()) {
                    throw new InvalidRequestException(StatementRestrictions.allowFilteringMessage(state));
                }
                this.isKeyRange = true;
                this.usesSecondaryIndexing = hasQueriableIndex;
            }
        }
    }

    public boolean hasPartitionKeyRestrictions() {
        return !this.partitionKeyRestrictions.isEmpty();
    }

    public boolean hasNonPrimaryKeyRestrictions() {
        return !this.nonPrimaryKeyRestrictions.isEmpty();
    }

    private Collection<ColumnIdentifier> getPartitionKeyUnrestrictedComponents() {
        ArrayList<ColumnMetadata> list = new ArrayList<ColumnMetadata>((Collection<ColumnMetadata>)this.table.partitionKeyColumns());
        list.removeAll(this.partitionKeyRestrictions.getColumnDefs());
        return ColumnMetadata.toIdentifiers(list);
    }

    public boolean isPartitionKeyRestrictionsOnToken() {
        return this.partitionKeyRestrictions.isOnToken();
    }

    public boolean clusteringKeyRestrictionsHasIN() {
        return this.clusteringColumnsRestrictions.hasIN();
    }

    private void processClusteringColumnsRestrictions(boolean hasQueriableIndex, boolean selectsOnlyStaticColumns, boolean forView, boolean allowFiltering) {
        RequestValidations.checkFalse(!this.type.allowClusteringColumnSlices() && this.clusteringColumnsRestrictions.hasSlice(), "Slice restrictions are not supported on the clustering columns in %s statements", (Object)this.type);
        if (!this.type.allowClusteringColumnSlices() && (!this.table.isCompactTable() || this.table.isCompactTable() && !this.hasClusteringColumnsRestrictions())) {
            if (!selectsOnlyStaticColumns && this.hasUnrestrictedClusteringColumns()) {
                throw RequestValidations.invalidRequest("Some clustering keys are missing: %s", Joiner.on((String)", ").join(this.getUnrestrictedClusteringColumns()));
            }
        } else {
            RequestValidations.checkFalse(this.clusteringColumnsRestrictions.hasContains() && !hasQueriableIndex && !allowFiltering, "Clustering columns can only be restricted with CONTAINS with a secondary index or filtering");
            if (this.hasClusteringColumnsRestrictions() && this.clusteringColumnsRestrictions.needFiltering()) {
                if (hasQueriableIndex || forView) {
                    this.usesSecondaryIndexing = true;
                } else if (!allowFiltering) {
                    ImmutableList<ColumnMetadata> clusteringColumns = this.table.clusteringColumns();
                    LinkedList<ColumnMetadata> restrictedColumns = new LinkedList<ColumnMetadata>(this.clusteringColumnsRestrictions.getColumnDefs());
                    int m = restrictedColumns.size();
                    for (int i = 0; i < m; ++i) {
                        ColumnMetadata restrictedColumn;
                        ColumnMetadata clusteringColumn = (ColumnMetadata)clusteringColumns.get(i);
                        if (clusteringColumn.equals(restrictedColumn = (ColumnMetadata)restrictedColumns.get(i))) continue;
                        throw RequestValidations.invalidRequest("PRIMARY KEY column \"%s\" cannot be restricted as preceding column \"%s\" is not restricted", restrictedColumn.name, clusteringColumn.name);
                    }
                }
            }
        }
    }

    private Collection<ColumnIdentifier> getUnrestrictedClusteringColumns() {
        ArrayList<ColumnMetadata> missingClusteringColumns = new ArrayList<ColumnMetadata>((Collection<ColumnMetadata>)this.table.clusteringColumns());
        missingClusteringColumns.removeAll(new LinkedList<ColumnMetadata>(this.clusteringColumnsRestrictions.getColumnDefs()));
        return ColumnMetadata.toIdentifiers(missingClusteringColumns);
    }

    private boolean hasUnrestrictedClusteringColumns() {
        return this.table.clusteringColumns().size() != this.clusteringColumnsRestrictions.size();
    }

    private void processCustomIndexExpressions(List<CustomIndexExpression> expressions, VariableSpecifications boundNames, IndexRegistry indexRegistry) {
        if (expressions.size() > 1) {
            throw new InvalidRequestException("Multiple custom index expressions in a single query are not supported");
        }
        CustomIndexExpression expression = expressions.get(0);
        QualifiedName name = expression.targetIndex;
        if (name.hasKeyspace() && !name.getKeyspace().equals(this.table.keyspace)) {
            throw IndexRestrictions.invalidIndex(expression.targetIndex, this.table);
        }
        if (!this.table.indexes.has(expression.targetIndex.getName())) {
            throw IndexRestrictions.indexNotFound(expression.targetIndex, this.table);
        }
        Index index = indexRegistry.getIndex(this.table.indexes.get(expression.targetIndex.getName()).get());
        if (!index.getIndexMetadata().isCustom()) {
            throw IndexRestrictions.nonCustomIndexInExpression(expression.targetIndex);
        }
        AbstractType<?> expressionType = index.customExpressionValueType();
        if (expressionType == null) {
            throw IndexRestrictions.customExpressionNotSupported(expression.targetIndex);
        }
        expression.prepareValue(this.table, expressionType, boundNames);
        this.filterRestrictions.add(expression);
    }

    public RowFilter getRowFilter(IndexRegistry indexRegistry, QueryOptions options) {
        if (this.filterRestrictions.isEmpty()) {
            return RowFilter.none();
        }
        boolean needsReconciliation = !this.table.isVirtual() && options.getConsistency().needsReconciliation() && Keyspace.open((String)this.table.keyspace).getReplicationStrategy().getReplicationFactor().allReplicas > 1;
        RowFilter filter = RowFilter.create(needsReconciliation);
        for (Restrictions restrictions : this.filterRestrictions.getRestrictions()) {
            restrictions.addToRowFilter(filter, indexRegistry, options);
        }
        for (CustomIndexExpression expression : this.filterRestrictions.getCustomIndexExpressions()) {
            expression.addToRowFilter(filter, this.table, options);
        }
        return filter;
    }

    public List<ByteBuffer> getPartitionKeys(QueryOptions options, ClientState state) {
        return this.partitionKeyRestrictions.values(options, state);
    }

    private ByteBuffer getPartitionKeyBound(Bound b, QueryOptions options) {
        return this.partitionKeyRestrictions.bounds(b, options).get(0);
    }

    public AbstractBounds<PartitionPosition> getPartitionKeyBounds(QueryOptions options) {
        IPartitioner p = this.table.partitioner;
        if (this.partitionKeyRestrictions.isOnToken()) {
            return this.getPartitionKeyBoundsForTokenRestrictions(p, options);
        }
        return this.getPartitionKeyBounds(p, options);
    }

    private AbstractBounds<PartitionPosition> getPartitionKeyBounds(IPartitioner p, QueryOptions options) {
        PartitionPosition finishKey;
        if (this.partitionKeyRestrictions.needFiltering(this.table)) {
            return new Range<PartitionPosition>(p.getMinimumToken().minKeyBound(), p.getMinimumToken().maxKeyBound());
        }
        ByteBuffer startKeyBytes = this.getPartitionKeyBound(Bound.START, options);
        ByteBuffer finishKeyBytes = this.getPartitionKeyBound(Bound.END, options);
        PartitionPosition startKey = PartitionPosition.ForKey.get(startKeyBytes, p);
        if (startKey.compareTo(finishKey = PartitionPosition.ForKey.get(finishKeyBytes, p)) > 0 && !finishKey.isMinimum()) {
            return null;
        }
        if (this.partitionKeyRestrictions.isInclusive(Bound.START)) {
            return this.partitionKeyRestrictions.isInclusive(Bound.END) ? new Bounds<PartitionPosition>(startKey, finishKey) : new IncludingExcludingBounds<PartitionPosition>(startKey, finishKey);
        }
        return this.partitionKeyRestrictions.isInclusive(Bound.END) ? new Range<PartitionPosition>(startKey, finishKey) : new ExcludingBounds<PartitionPosition>(startKey, finishKey);
    }

    private AbstractBounds<PartitionPosition> getPartitionKeyBoundsForTokenRestrictions(IPartitioner p, QueryOptions options) {
        Token startToken = this.getTokenBound(Bound.START, options, p);
        Token endToken = this.getTokenBound(Bound.END, options, p);
        boolean includeStart = this.partitionKeyRestrictions.isInclusive(Bound.START);
        boolean includeEnd = this.partitionKeyRestrictions.isInclusive(Bound.END);
        int cmp = startToken.compareTo(endToken);
        if (!(startToken.isMinimum() || endToken.isMinimum() || cmp <= 0 && (cmp != 0 || includeStart && includeEnd))) {
            return null;
        }
        Token.KeyBound start = includeStart ? startToken.minKeyBound() : startToken.maxKeyBound();
        Token.KeyBound end = includeEnd ? endToken.maxKeyBound() : endToken.minKeyBound();
        return new Range<PartitionPosition>(start, end);
    }

    private Token getTokenBound(Bound b, QueryOptions options, IPartitioner p) {
        if (!this.partitionKeyRestrictions.hasBound(b)) {
            return p.getMinimumToken();
        }
        ByteBuffer value = this.partitionKeyRestrictions.bounds(b, options).get(0);
        RequestValidations.checkNotNull(value, "Invalid null token value");
        return p.getTokenFactory().fromByteArray(value);
    }

    public boolean hasClusteringColumnsRestrictions() {
        return !this.clusteringColumnsRestrictions.isEmpty();
    }

    public NavigableSet<Clustering<?>> getClusteringColumns(QueryOptions options, ClientState state) {
        if (this.table.isStaticCompactTable()) {
            return BTreeSet.empty(this.table.comparator);
        }
        return this.clusteringColumnsRestrictions.valuesAsClustering(options, state);
    }

    public NavigableSet<ClusteringBound<?>> getClusteringColumnsBounds(Bound b, QueryOptions options) {
        return this.clusteringColumnsRestrictions.boundsAsClustering(b, options);
    }

    public boolean isColumnRange() {
        int numberOfClusteringColumns = this.table.clusteringColumns().size();
        if (this.table.isStaticCompactTable()) {
            numberOfClusteringColumns = 0;
        }
        return this.clusteringColumnsRestrictions.size() < numberOfClusteringColumns || !this.clusteringColumnsRestrictions.hasOnlyEqualityRestrictions();
    }

    public boolean needFiltering(TableMetadata table) {
        IndexRegistry indexRegistry = IndexRegistry.obtain(table);
        if (this.filterRestrictions.needsFiltering(indexRegistry)) {
            return true;
        }
        int numberOfRestrictions = this.filterRestrictions.getCustomIndexExpressions().size();
        for (Restrictions restrictions : this.filterRestrictions.getRestrictions()) {
            numberOfRestrictions += restrictions.size();
        }
        return numberOfRestrictions == 0 && !this.clusteringColumnsRestrictions.isEmpty();
    }

    private void validateSecondaryIndexSelections() {
        RequestValidations.checkFalse(this.keyIsInRelation(), "Select on indexed columns and with IN clause for the PRIMARY KEY are not supported");
    }

    public boolean hasAllPKColumnsRestrictedByEqualities() {
        return !this.isPartitionKeyRestrictionsOnToken() && !this.partitionKeyRestrictions.hasUnrestrictedPartitionKeyComponents(this.table) && this.partitionKeyRestrictions.hasOnlyEqualityRestrictions() && !this.hasUnrestrictedClusteringColumns() && this.clusteringColumnsRestrictions.hasOnlyEqualityRestrictions();
    }

    public boolean hasRegularColumnsRestrictions() {
        return this.hasRegularColumnsRestrictions;
    }

    private boolean queriesFullPartitions() {
        return !this.hasClusteringColumnsRestrictions() && !this.hasRegularColumnsRestrictions();
    }

    public boolean returnStaticContentOnPartitionWithNoRows() {
        if (this.table.isStaticCompactTable()) {
            return true;
        }
        return this.queriesFullPartitions();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    private static String allowFilteringMessage(ClientState state) {
        return Guardrails.allowFilteringEnabled.isEnabled(state) ? REQUIRES_ALLOW_FILTERING_MESSAGE : CANNOT_USE_ALLOW_FILTERING_MESSAGE;
    }
}

