/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.fqltool;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.cassandra.concurrent.ExecutorFactory;
import org.apache.cassandra.fqltool.DriverResultSet;
import org.apache.cassandra.fqltool.FQLQuery;
import org.apache.cassandra.fqltool.MismatchListener;
import org.apache.cassandra.fqltool.ResultHandler;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryReplayer
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(QueryReplayer.class);
    private static final int PRINT_RATE = 5000;
    private final ExecutorService es = ExecutorFactory.Global.executorFactory().sequential("QueryReplayer");
    private final Iterator<List<FQLQuery>> queryIterator;
    private final List<Predicate<FQLQuery>> filters;
    private final List<Session> sessions;
    private final ResultHandler resultHandler;
    private final MetricRegistry metrics = new MetricRegistry();
    private final SessionProvider sessionProvider;

    public QueryReplayer(Iterator<List<FQLQuery>> queryIterator, List<String> targetHosts, List<File> resultPaths, List<Predicate<FQLQuery>> filters, String queryFilePathString) {
        this(queryIterator, targetHosts, resultPaths, filters, queryFilePathString, new DefaultSessionProvider(), null);
    }

    public QueryReplayer(Iterator<List<FQLQuery>> queryIterator, List<String> targetHosts, List<File> resultPaths, List<Predicate<FQLQuery>> filters, String queryFilePathString, SessionProvider sessionProvider, MismatchListener mismatchListener) {
        this.sessionProvider = sessionProvider;
        this.queryIterator = queryIterator;
        this.filters = filters;
        this.sessions = targetHosts.stream().map(sessionProvider::connect).collect(Collectors.toList());
        File queryFilePath = queryFilePathString != null ? new File(queryFilePathString) : null;
        this.resultHandler = new ResultHandler(targetHosts, resultPaths, queryFilePath, mismatchListener);
    }

    public void replay() {
        while (this.queryIterator.hasNext()) {
            List<FQLQuery> queries = this.queryIterator.next();
            for (final FQLQuery query : queries) {
                Timer timer;
                if (this.filters.stream().anyMatch(f -> !f.test(query))) continue;
                try (Timer.Context ctx = this.metrics.timer("queries").time();){
                    ArrayList<ListenableFuture<ResultHandler.ComparableResultSet>> results = new ArrayList<ListenableFuture<ResultHandler.ComparableResultSet>>(this.sessions.size());
                    Statement statement = query.toStatement();
                    for (Session session : this.sessions) {
                        this.maybeSetKeyspace(session, query);
                        if (logger.isDebugEnabled()) {
                            logger.debug("Executing query: {}", (Object)query);
                        }
                        ResultSetFuture future = session.executeAsync(statement);
                        results.add(QueryReplayer.handleErrors((ListenableFuture<ResultSet>)future));
                    }
                    ListenableFuture resultList = Futures.allAsList(results);
                    Futures.addCallback((ListenableFuture)resultList, (FutureCallback)new FutureCallback<List<ResultHandler.ComparableResultSet>>(){

                        public void onSuccess(List<ResultHandler.ComparableResultSet> resultSets) {
                            QueryReplayer.this.resultHandler.handleResults(query, resultSets);
                        }

                        public void onFailure(Throwable throwable) {
                            throw new AssertionError("Errors should be handled in FQLQuery.execute", throwable);
                        }
                    }, (Executor)this.es);
                    FBUtilities.waitOnFuture((Future)resultList);
                }
                catch (Throwable t) {
                    logger.error("QUERY %s got exception: %s", (Object)query, (Object)t.getMessage());
                }
                if ((timer = this.metrics.timer("queries")).getCount() % 5000L != 0L) continue;
                logger.info(String.format("%d queries, rate = %.2f", timer.getCount(), timer.getOneMinuteRate()));
            }
        }
    }

    private void maybeSetKeyspace(Session session, FQLQuery query) {
        try {
            if (query.keyspace() != null && !query.keyspace().equals(session.getLoggedKeyspace())) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Switching keyspace from {} to {}", (Object)session.getLoggedKeyspace(), (Object)query.keyspace());
                }
                session.execute("USE " + query.keyspace());
            }
        }
        catch (Throwable t) {
            logger.error("USE {} failed: {}", (Object)query.keyspace(), (Object)t.getMessage());
        }
    }

    private static ListenableFuture<ResultHandler.ComparableResultSet> handleErrors(ListenableFuture<ResultSet> result) {
        ListenableFuture res = Futures.transform(result, DriverResultSet::new, (Executor)MoreExecutors.directExecutor());
        return Futures.catching((ListenableFuture)res, Throwable.class, DriverResultSet::failed, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public void close() throws IOException {
        this.es.shutdown();
        this.sessionProvider.close();
        this.resultHandler.close();
    }

    private static final class DefaultSessionProvider
    implements SessionProvider {
        private static final Map<String, Session> sessionCache = new HashMap<String, Session>();

        private DefaultSessionProvider() {
        }

        @Override
        public synchronized Session connect(String connectionString) {
            if (sessionCache.containsKey(connectionString)) {
                return sessionCache.get(connectionString);
            }
            Cluster.Builder builder = Cluster.builder();
            ParsedTargetHost pth = ParsedTargetHost.fromString(connectionString);
            builder.addContactPoint(pth.host);
            builder.withPort(pth.port);
            if (pth.user != null) {
                builder.withCredentials(pth.user, pth.password);
            }
            Cluster c = builder.build();
            sessionCache.put(connectionString, c.connect());
            return sessionCache.get(connectionString);
        }

        @Override
        public void close() {
            sessionCache.entrySet().removeIf(entry -> {
                boolean bl;
                block8: {
                    Session s = (Session)entry.getValue();
                    try {
                        s.getCluster().close();
                        bl = true;
                        if (s == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (s != null) {
                                try {
                                    s.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Throwable t) {
                            logger.error("Could not close connection", t);
                            return false;
                        }
                    }
                    s.close();
                }
                return bl;
            });
        }
    }

    public static interface SessionProvider
    extends Closeable {
        public Session connect(String var1);

        @Override
        public void close();
    }

    static class ParsedTargetHost {
        final int port;
        final String user;
        final String password;
        final String host;

        ParsedTargetHost(String host, int port, String user, String password) {
            this.host = host;
            this.port = port;
            this.user = user;
            this.password = password;
        }

        static ParsedTargetHost fromString(String s) {
            String[] userInfoHostPort = s.split("@");
            String hostPort = null;
            String user = null;
            String password = null;
            if (userInfoHostPort.length == 2) {
                String[] userPassword = userInfoHostPort[0].split(":");
                if (userPassword.length != 2) {
                    throw new RuntimeException("Username provided but no password");
                }
                hostPort = userInfoHostPort[1];
                user = userPassword[0];
                password = userPassword[1];
            } else if (userInfoHostPort.length == 1) {
                hostPort = userInfoHostPort[0];
            } else {
                throw new RuntimeException("Malformed target host: " + s);
            }
            String[] splitHostPort = hostPort.split(":");
            int port = 9042;
            if (splitHostPort.length == 2) {
                port = Integer.parseInt(splitHostPort[1]);
            }
            return new ParsedTargetHost(splitHostPort[0], port, user, password);
        }
    }
}

