/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class RMIClientSocketFactoryImpl
implements RMIClientSocketFactory,
Serializable {
    List<Socket> sockets = new ArrayList<Socket>();
    private final InetAddress localAddress;

    public RMIClientSocketFactoryImpl(InetAddress localAddress) {
        this.localAddress = localAddress;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        Socket socket = new Socket(this.localAddress, port);
        this.sockets.add(socket);
        return socket;
    }

    public void close() throws IOException {
        for (Socket socket : this.sockets) {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RMIClientSocketFactoryImpl that = (RMIClientSocketFactoryImpl)o;
        return Objects.equals(this.localAddress, that.localAddress);
    }

    public int hashCode() {
        return Objects.hash(this.localAddress);
    }
}

