/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.chunked;

import java.nio.ByteBuffer;
import org.caffinitas.ohc.chunked.Hasher;

final class KeyBuffer {
    private final ByteBuffer bytes;
    private long hash;

    KeyBuffer(ByteBuffer bytes) {
        this.bytes = bytes;
    }

    ByteBuffer buffer() {
        return this.bytes;
    }

    int size() {
        return this.bytes.limit() - this.bytes.position();
    }

    long hash() {
        return this.hash;
    }

    KeyBuffer finish(Hasher hasher) {
        this.hash = hasher.hash(this.bytes.duplicate());
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyBuffer keyBuffer = (KeyBuffer)o;
        return this.bytes.equals(keyBuffer.bytes);
    }

    public int hashCode() {
        return (int)this.hash;
    }

    private static String padToEight(int val) {
        String str = Integer.toBinaryString(val & 0xFF);
        while (str.length() < 8) {
            str = '0' + str;
        }
        return str;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int ii = 0; ii < this.bytes.limit(); ++ii) {
            if (ii % 8 == 0 && ii != 0) {
                sb.append('\n');
            }
            sb.append(KeyBuffer.padToEight(this.bytes.get(ii)));
            sb.append(' ');
        }
        return sb.toString();
    }
}

