/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.cassandra.net.AsyncPromise;
import org.apache.cassandra.net.FutureDelegate;

class FutureCombiner
extends FutureDelegate<Void> {
    private volatile boolean failed;
    private volatile Throwable firstCause;
    private static final AtomicReferenceFieldUpdater<FutureCombiner, Throwable> firstCauseUpdater = AtomicReferenceFieldUpdater.newUpdater(FutureCombiner.class, Throwable.class, "firstCause");
    private volatile int waitingOn;
    private static final AtomicIntegerFieldUpdater<FutureCombiner> waitingOnUpdater = AtomicIntegerFieldUpdater.newUpdater(FutureCombiner.class, "waitingOn");

    FutureCombiner(Collection<? extends Future<?>> combine) {
        this(AsyncPromise.uncancellable((EventExecutor)GlobalEventExecutor.INSTANCE), combine);
    }

    private FutureCombiner(Promise<Void> combined, Collection<? extends Future<?>> combine) {
        super(combined);
        this.waitingOn = combine.size();
        if (0 == this.waitingOn) {
            combined.trySuccess(null);
        }
        GenericFutureListener listener = result -> {
            if (!result.isSuccess()) {
                firstCauseUpdater.compareAndSet(this, null, result.cause());
                this.failed = true;
            }
            if (0 == waitingOnUpdater.decrementAndGet(this)) {
                if (this.failed) {
                    combined.tryFailure(this.firstCause);
                } else {
                    combined.trySuccess(null);
                }
            }
        };
        for (Future<?> future : combine) {
            future.addListener(listener);
        }
    }
}

