/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import java.util.Objects;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.security.SSLFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionOptions {
    Logger logger = LoggerFactory.getLogger(EncryptionOptions.class);
    public final String keystore;
    public final String keystore_password;
    public final String truststore;
    public final String truststore_password;
    public final List<String> cipher_suites;
    protected String protocol;
    protected List<String> accepted_protocols;
    public final String algorithm;
    public final String store_type;
    public final boolean require_client_auth;
    public final boolean require_endpoint_verification;
    protected Boolean enabled;
    protected Boolean optional;
    protected Boolean isEnabled = null;
    protected Boolean isOptional = null;
    private static final List<String> TLS_PROTOCOL_SUBSTITUTION = SSLFactory.tlsInstanceProtocolSubstitution();

    public EncryptionOptions() {
        this.keystore = "conf/.keystore";
        this.keystore_password = "cassandra";
        this.truststore = "conf/.truststore";
        this.truststore_password = "cassandra";
        this.cipher_suites = null;
        this.protocol = null;
        this.accepted_protocols = null;
        this.algorithm = null;
        this.store_type = "JKS";
        this.require_client_auth = false;
        this.require_endpoint_verification = false;
        this.enabled = null;
        this.optional = null;
    }

    public EncryptionOptions(String keystore, String keystore_password, String truststore, String truststore_password, List<String> cipher_suites, String protocol, List<String> accepted_protocols, String algorithm, String store_type, boolean require_client_auth, boolean require_endpoint_verification, Boolean enabled, Boolean optional) {
        this.keystore = keystore;
        this.keystore_password = keystore_password;
        this.truststore = truststore;
        this.truststore_password = truststore_password;
        this.cipher_suites = cipher_suites;
        this.protocol = protocol;
        this.accepted_protocols = accepted_protocols;
        this.algorithm = algorithm;
        this.store_type = store_type;
        this.require_client_auth = require_client_auth;
        this.require_endpoint_verification = require_endpoint_verification;
        this.enabled = enabled;
        this.optional = optional;
    }

    public EncryptionOptions(EncryptionOptions options) {
        this.keystore = options.keystore;
        this.keystore_password = options.keystore_password;
        this.truststore = options.truststore;
        this.truststore_password = options.truststore_password;
        this.cipher_suites = options.cipher_suites;
        this.protocol = options.protocol;
        this.accepted_protocols = options.accepted_protocols;
        this.algorithm = options.algorithm;
        this.store_type = options.store_type;
        this.require_client_auth = options.require_client_auth;
        this.require_endpoint_verification = options.require_endpoint_verification;
        this.enabled = options.enabled;
        this.optional = options.optional;
    }

    public EncryptionOptions applyConfig() {
        this.ensureConfigNotApplied();
        this.isEnabled = this.enabled != null && this.enabled != false;
        this.isOptional = this.optional != null ? this.optional : (new File(this.keystore).exists() ? Boolean.valueOf(this.isEnabled == false) : Boolean.valueOf(false));
        return this;
    }

    private void ensureConfigApplied() {
        if (this.isEnabled == null || this.isOptional == null) {
            throw new IllegalStateException("EncryptionOptions.applyConfig must be called first");
        }
    }

    private void ensureConfigNotApplied() {
        if (this.isEnabled != null || this.isOptional != null) {
            throw new IllegalStateException("EncryptionOptions cannot be changed after configuration applied");
        }
    }

    public Boolean isEnabled() {
        this.ensureConfigApplied();
        return this.isEnabled;
    }

    public void setEnabled(Boolean enabled) {
        this.ensureConfigNotApplied();
        this.enabled = enabled;
    }

    public Boolean isOptional() {
        this.ensureConfigApplied();
        return this.isOptional;
    }

    public void setOptional(boolean optional) {
        this.ensureConfigNotApplied();
        this.optional = optional;
    }

    @VisibleForTesting
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setaccepted_protocols(List<String> accepted_protocols) {
        this.accepted_protocols = accepted_protocols == null ? null : ImmutableList.copyOf(accepted_protocols);
    }

    public List<String> acceptedProtocols() {
        if (this.accepted_protocols == null) {
            if (this.protocol == null) {
                return null;
            }
            if (this.protocol.equalsIgnoreCase("TLS")) {
                return TLS_PROTOCOL_SUBSTITUTION;
            }
            return ImmutableList.of((Object)this.protocol);
        }
        if (this.protocol != null && !this.protocol.equalsIgnoreCase("TLS") && this.accepted_protocols.stream().noneMatch(ap -> ap.equalsIgnoreCase(this.protocol))) {
            return ImmutableList.builder().addAll(this.accepted_protocols).add((Object)this.protocol).build();
        }
        return this.accepted_protocols;
    }

    public String[] acceptedProtocolsArray() {
        List<String> ap = this.acceptedProtocols();
        return ap == null ? new String[]{} : ap.toArray(new String[0]);
    }

    public String[] cipherSuitesArray() {
        return this.cipher_suites == null ? null : this.cipher_suites.toArray(new String[0]);
    }

    public TlsEncryptionPolicy tlsEncryptionPolicy() {
        if (this.isOptional().booleanValue()) {
            return TlsEncryptionPolicy.OPTIONAL;
        }
        if (this.isEnabled().booleanValue()) {
            return TlsEncryptionPolicy.ENCRYPTED;
        }
        return TlsEncryptionPolicy.UNENCRYPTED;
    }

    public EncryptionOptions withKeyStore(String keystore) {
        return new EncryptionOptions(keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional).applyConfig();
    }

    public EncryptionOptions withKeyStorePassword(String keystore_password) {
        return new EncryptionOptions(this.keystore, keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional).applyConfig();
    }

    public EncryptionOptions withTrustStore(String truststore) {
        return new EncryptionOptions(this.keystore, this.keystore_password, truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional).applyConfig();
    }

    public EncryptionOptions withTrustStorePassword(String truststore_password) {
        return new EncryptionOptions(this.keystore, this.keystore_password, this.truststore, truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional).applyConfig();
    }

    public EncryptionOptions withCipherSuites(List<String> cipher_suites) {
        return new EncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional).applyConfig();
    }

    public EncryptionOptions withCipherSuites(String ... cipher_suites) {
        return new EncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, (List<String>)ImmutableList.copyOf((Object[])cipher_suites), this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional).applyConfig();
    }

    public EncryptionOptions withProtocol(String protocol) {
        return new EncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional).applyConfig();
    }

    public EncryptionOptions withAcceptedProtocols(List<String> accepted_protocols) {
        return new EncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, (List<String>)(accepted_protocols == null ? null : ImmutableList.copyOf(accepted_protocols)), this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional).applyConfig();
    }

    public EncryptionOptions withAlgorithm(String algorithm) {
        return new EncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional).applyConfig();
    }

    public EncryptionOptions withStoreType(String store_type) {
        return new EncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, this.optional).applyConfig();
    }

    public EncryptionOptions withRequireClientAuth(boolean require_client_auth) {
        return new EncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, require_client_auth, this.require_endpoint_verification, this.enabled, this.optional).applyConfig();
    }

    public EncryptionOptions withRequireEndpointVerification(boolean require_endpoint_verification) {
        return new EncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, require_endpoint_verification, this.enabled, this.optional).applyConfig();
    }

    public EncryptionOptions withEnabled(boolean enabled) {
        return new EncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, enabled, this.optional).applyConfig();
    }

    public EncryptionOptions withOptional(Boolean optional) {
        return new EncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.enabled, optional).applyConfig();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncryptionOptions opt = (EncryptionOptions)o;
        return this.enabled == opt.enabled && this.optional == opt.optional && this.require_client_auth == opt.require_client_auth && this.require_endpoint_verification == opt.require_endpoint_verification && Objects.equals(this.keystore, opt.keystore) && Objects.equals(this.keystore_password, opt.keystore_password) && Objects.equals(this.truststore, opt.truststore) && Objects.equals(this.truststore_password, opt.truststore_password) && Objects.equals(this.protocol, opt.protocol) && Objects.equals(this.accepted_protocols, opt.accepted_protocols) && Objects.equals(this.algorithm, opt.algorithm) && Objects.equals(this.store_type, opt.store_type) && Objects.equals(this.cipher_suites, opt.cipher_suites);
    }

    public int hashCode() {
        int result = 0;
        result += 31 * (this.keystore == null ? 0 : this.keystore.hashCode());
        result += 31 * (this.keystore_password == null ? 0 : this.keystore_password.hashCode());
        result += 31 * (this.truststore == null ? 0 : this.truststore.hashCode());
        result += 31 * (this.truststore_password == null ? 0 : this.truststore_password.hashCode());
        result += 31 * (this.protocol == null ? 0 : this.protocol.hashCode());
        result += 31 * (this.accepted_protocols == null ? 0 : this.accepted_protocols.hashCode());
        result += 31 * (this.algorithm == null ? 0 : this.algorithm.hashCode());
        result += 31 * (this.store_type == null ? 0 : this.store_type.hashCode());
        result += 31 * (this.enabled == null ? 0 : Boolean.hashCode(this.enabled));
        result += 31 * (this.optional == null ? 0 : Boolean.hashCode(this.optional));
        result += 31 * (this.cipher_suites == null ? 0 : this.cipher_suites.hashCode());
        result += 31 * Boolean.hashCode(this.require_client_auth);
        return result += 31 * Boolean.hashCode(this.require_endpoint_verification);
    }

    public static class ServerEncryptionOptions
    extends EncryptionOptions {
        public final InternodeEncryption internode_encryption;
        public final boolean enable_legacy_ssl_storage_port;

        public ServerEncryptionOptions() {
            this.internode_encryption = InternodeEncryption.none;
            this.enable_legacy_ssl_storage_port = false;
        }

        public ServerEncryptionOptions(String keystore, String keystore_password, String truststore, String truststore_password, List<String> cipher_suites, String protocol, List<String> accepted_protocols, String algorithm, String store_type, boolean require_client_auth, boolean require_endpoint_verification, Boolean optional, InternodeEncryption internode_encryption, boolean enable_legacy_ssl_storage_port) {
            super(keystore, keystore_password, truststore, truststore_password, cipher_suites, protocol, accepted_protocols, algorithm, store_type, require_client_auth, require_endpoint_verification, null, optional);
            this.internode_encryption = internode_encryption;
            this.enable_legacy_ssl_storage_port = enable_legacy_ssl_storage_port;
        }

        public ServerEncryptionOptions(ServerEncryptionOptions options) {
            super(options);
            this.internode_encryption = options.internode_encryption;
            this.enable_legacy_ssl_storage_port = options.enable_legacy_ssl_storage_port;
        }

        @Override
        public EncryptionOptions applyConfig() {
            return this.applyConfigInternal();
        }

        private ServerEncryptionOptions applyConfigInternal() {
            super.applyConfig();
            this.isEnabled = this.internode_encryption != InternodeEncryption.none;
            if (this.enabled != null && this.enabled.booleanValue() && !this.isEnabled.booleanValue()) {
                this.logger.warn("Setting server_encryption_options.enabled has no effect, use internode_encryption");
            }
            if (this.require_client_auth && (this.internode_encryption == InternodeEncryption.rack || this.internode_encryption == InternodeEncryption.dc)) {
                this.logger.warn("Setting require_client_auth is incompatible with 'rack' and 'dc' internode_encryption values. It is possible for an internode connection to pretend to be in the same rack/dc by spoofing its broadcast address in the handshake and bypass authentication. To ensure that mutual TLS authentication is not bypassed, please set internode_encryption to 'all'. Continuing with insecure configuration.");
            }
            this.isOptional = this.isOptional != false || this.internode_encryption == InternodeEncryption.rack || this.internode_encryption == InternodeEncryption.dc;
            return this;
        }

        public boolean shouldEncrypt(InetAddressAndPort endpoint) {
            IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
            switch (this.internode_encryption) {
                case none: {
                    return false;
                }
                case all: {
                    break;
                }
                case dc: {
                    if (!snitch.getDatacenter(endpoint).equals(snitch.getLocalDatacenter())) break;
                    return false;
                }
                case rack: {
                    if (!snitch.getRack(endpoint).equals(snitch.getLocalRack()) || !snitch.getDatacenter(endpoint).equals(snitch.getLocalDatacenter())) break;
                    return false;
                }
            }
            return true;
        }

        public boolean isExplicitlyOptional() {
            return this.optional != null && this.optional != false;
        }

        @Override
        public ServerEncryptionOptions withKeyStore(String keystore) {
            return new ServerEncryptionOptions(keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.optional, this.internode_encryption, this.enable_legacy_ssl_storage_port).applyConfigInternal();
        }

        @Override
        public ServerEncryptionOptions withKeyStorePassword(String keystore_password) {
            return new ServerEncryptionOptions(this.keystore, keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.optional, this.internode_encryption, this.enable_legacy_ssl_storage_port).applyConfigInternal();
        }

        @Override
        public ServerEncryptionOptions withTrustStore(String truststore) {
            return new ServerEncryptionOptions(this.keystore, this.keystore_password, truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.optional, this.internode_encryption, this.enable_legacy_ssl_storage_port).applyConfigInternal();
        }

        @Override
        public ServerEncryptionOptions withTrustStorePassword(String truststore_password) {
            return new ServerEncryptionOptions(this.keystore, this.keystore_password, this.truststore, truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.optional, this.internode_encryption, this.enable_legacy_ssl_storage_port).applyConfigInternal();
        }

        @Override
        public ServerEncryptionOptions withCipherSuites(List<String> cipher_suites) {
            return new ServerEncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.optional, this.internode_encryption, this.enable_legacy_ssl_storage_port).applyConfigInternal();
        }

        @Override
        public ServerEncryptionOptions withCipherSuites(String ... cipher_suites) {
            return new ServerEncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, (List<String>)ImmutableList.copyOf((Object[])cipher_suites), this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.optional, this.internode_encryption, this.enable_legacy_ssl_storage_port).applyConfigInternal();
        }

        @Override
        public ServerEncryptionOptions withProtocol(String protocol) {
            return new ServerEncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.optional, this.internode_encryption, this.enable_legacy_ssl_storage_port).applyConfigInternal();
        }

        @Override
        public ServerEncryptionOptions withAcceptedProtocols(List<String> accepted_protocols) {
            return new ServerEncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, (List<String>)(accepted_protocols == null ? null : ImmutableList.copyOf(accepted_protocols)), this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.optional, this.internode_encryption, this.enable_legacy_ssl_storage_port).applyConfigInternal();
        }

        @Override
        public ServerEncryptionOptions withAlgorithm(String algorithm) {
            return new ServerEncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.optional, this.internode_encryption, this.enable_legacy_ssl_storage_port).applyConfigInternal();
        }

        @Override
        public ServerEncryptionOptions withStoreType(String store_type) {
            return new ServerEncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, store_type, this.require_client_auth, this.require_endpoint_verification, this.optional, this.internode_encryption, this.enable_legacy_ssl_storage_port).applyConfigInternal();
        }

        @Override
        public ServerEncryptionOptions withRequireClientAuth(boolean require_client_auth) {
            return new ServerEncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, require_client_auth, this.require_endpoint_verification, this.optional, this.internode_encryption, this.enable_legacy_ssl_storage_port).applyConfigInternal();
        }

        @Override
        public ServerEncryptionOptions withRequireEndpointVerification(boolean require_endpoint_verification) {
            return new ServerEncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, require_endpoint_verification, this.optional, this.internode_encryption, this.enable_legacy_ssl_storage_port).applyConfigInternal();
        }

        public ServerEncryptionOptions withOptional(boolean optional) {
            return new ServerEncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, optional, this.internode_encryption, this.enable_legacy_ssl_storage_port).applyConfigInternal();
        }

        public ServerEncryptionOptions withInternodeEncryption(InternodeEncryption internode_encryption) {
            return new ServerEncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.optional, internode_encryption, this.enable_legacy_ssl_storage_port).applyConfigInternal();
        }

        public ServerEncryptionOptions withLegacySslStoragePort(boolean enable_legacy_ssl_storage_port) {
            return new ServerEncryptionOptions(this.keystore, this.keystore_password, this.truststore, this.truststore_password, this.cipher_suites, this.protocol, this.accepted_protocols, this.algorithm, this.store_type, this.require_client_auth, this.require_endpoint_verification, this.optional, this.internode_encryption, enable_legacy_ssl_storage_port).applyConfigInternal();
        }

        public static enum InternodeEncryption {
            all,
            none,
            dc,
            rack;

        }
    }

    public static enum TlsEncryptionPolicy {
        UNENCRYPTED("unencrypted"),
        OPTIONAL("optionally encrypted"),
        ENCRYPTED("encrypted");

        private final String description;

        private TlsEncryptionPolicy(String description) {
            this.description = description;
        }

        public String description() {
            return this.description;
        }
    }
}

