/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.ds.tree.binary.bst;

import java.util.Comparator;
import java.util.Iterator;
import org.psjava.ds.KeyValuePair;
import org.psjava.ds.tree.binary.BinaryTreeNodeUtil;
import org.psjava.ds.tree.binary.BinaryTreeNodeWithParent;
import org.psjava.ds.tree.binary.BinaryTreeNodeWithParentFactory;
import org.psjava.ds.tree.binary.BinaryTreeToString;
import org.psjava.ds.tree.binary.InOrderIterator;
import org.psjava.ds.tree.binary.bst.InsertionResult;
import org.psjava.ds.tree.binary.bst.MinimumFinder;
import org.psjava.ds.tree.binary.bst.RemoveResult;

public class BinarySearchTree<K, V> {
    private final Comparator<K> comparator;
    private BinaryTreeNodeWithParent<NodeData<K, V>> rootOrNull = null;

    public BinarySearchTree(Comparator<K> comparator) {
        this.comparator = comparator;
    }

    public InsertionResult insertOrUpdate(K key, V value) {
        if (this.rootOrNull == null) {
            this.rootOrNull = BinaryTreeNodeWithParentFactory.create(new NodeData<K, V>(key, value));
            return InsertionResult.INSERTED;
        }
        return this.insertOrUpdateRecursively(this.rootOrNull, key, value);
    }

    private InsertionResult insertOrUpdateRecursively(BinaryTreeNodeWithParent<NodeData<K, V>> node, K key, V value) {
        int comp = this.comparator.compare(key, node.getData().key);
        if (comp == 0) {
            node.setData(new NodeData<K, V>(key, value));
            return InsertionResult.UPDATED;
        }
        if (comp < 0) {
            if (node.hasLeft()) {
                return this.insertOrUpdateRecursively(node.getLeft(), key, value);
            }
            BinaryTreeNodeUtil.connectAsLeftChild(BinaryTreeNodeWithParentFactory.create(new NodeData<K, V>(key, value)), node);
            return InsertionResult.INSERTED;
        }
        if (node.hasRight()) {
            return this.insertOrUpdateRecursively(node.getRight(), key, value);
        }
        BinaryTreeNodeUtil.connectAsRightChild(BinaryTreeNodeWithParentFactory.create(new NodeData<K, V>(key, value)), node);
        return InsertionResult.INSERTED;
    }

    public KeyValuePair<K, V> findPairOrNull(K key) {
        BinaryTreeNodeWithParent<NodeData<K, V>> node = this.findNodeOrNull(key);
        if (node == null) {
            return null;
        }
        return node.getData();
    }

    protected BinaryTreeNodeWithParent<NodeData<K, V>> findNodeOrNull(K key) {
        if (this.rootOrNull == null) {
            return null;
        }
        return this.findNodeOrNullRecursively(this.rootOrNull, key);
    }

    private BinaryTreeNodeWithParent<NodeData<K, V>> findNodeOrNullRecursively(BinaryTreeNodeWithParent<NodeData<K, V>> node, K key) {
        int comp = this.comparator.compare(node.getData().key, key);
        if (comp == 0) {
            return node;
        }
        if (comp < 0) {
            if (node.hasRight()) {
                return this.findNodeOrNullRecursively(node.getRight(), key);
            }
            return null;
        }
        if (node.hasLeft()) {
            return this.findNodeOrNullRecursively(node.getLeft(), key);
        }
        return null;
    }

    public RemoveResult removeIfExist(K key) {
        BinaryTreeNodeWithParent<NodeData<K, V>> node = this.findNodeOrNull(key);
        if (node == null) {
            return RemoveResult.NOT_EXIST;
        }
        if (!node.hasLeft() && !node.hasRight()) {
            if (this.rootOrNull == node) {
                this.rootOrNull = null;
            } else {
                BinaryTreeNodeUtil.disconnectFromParent(node);
            }
        } else if (node.hasLeft() && node.hasRight()) {
            BinaryTreeNodeWithParent<NodeData<K, V>> successor = MinimumFinder.find(node.getRight());
            node.setData(successor.getData());
            if (successor.hasRight()) {
                BinaryTreeNodeWithParent<NodeData<K, V>> right = successor.getRight();
                BinaryTreeNodeUtil.disconnectFromParent(right);
                BinaryTreeNodeUtil.replaceNode(successor, right);
            } else {
                BinaryTreeNodeUtil.disconnectFromParent(successor);
            }
        } else {
            BinaryTreeNodeWithParent<NodeData<K, V>> child = BinaryTreeNodeUtil.getAnyChild(node);
            BinaryTreeNodeUtil.disconnectFromParent(child);
            if (this.rootOrNull == node) {
                this.rootOrNull = child;
            } else {
                BinaryTreeNodeUtil.replaceNode(node, child);
            }
        }
        return RemoveResult.REMOVED;
    }

    public void clear() {
        this.rootOrNull = null;
    }

    public Iterator<KeyValuePair<K, V>> getInOrderIterator() {
        return InOrderIterator.create(this.rootOrNull);
    }

    public String toString() {
        return BinaryTreeToString.toString(this.rootOrNull);
    }

    public static class NodeData<K, V>
    implements KeyValuePair<K, V> {
        public final K key;
        public V value;

        public NodeData(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

